
//Title:        Your Product Name
//Version:      
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

package org.trinet.jiggle;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.util.StringTokenizer;
import javax.swing.border.*;
import javax.swing.border.TitledBorder;

import org.trinet.jasi.ActiveList;

/**
* Presents a panel that allows selection of WaveServer attributes.
*/
public class WaveServerGroupDialogPanel extends JPanel {

     WaveServerGroup wsg = new WaveServerGroup("<new>") ;

     ActiveList wsgList = new ActiveList();

// This code is messy because it was partially generated by JBuilder GUI designer.
     JButton saveButton = new JButton();
     BorderLayout borderLayout1 = new BorderLayout();
     JButton resetlButton = new JButton();
     JPanel buttonPanel = new JPanel();
     JButton testButton = new JButton();
     JPanel paramPanel = new JPanel();
     GridLayout gridLayout1 = new GridLayout();
     JLabel retryLabel = new JLabel();
     JLabel timeoutLable = new JLabel();
     JTextField retryField = new JTextField();
     JTextField timeoutField = new JTextField();
     JCheckBox verifyCheck = new JCheckBox();
     JCheckBox truncateCheck = new JCheckBox();

     JPanel listPanel = new JPanel();
     JScrollPane scrollPane = new JScrollPane();

     JTextArea textArea = new JTextArea(wsg.listToString());
     JLabel groupName = new JLabel();
     JTextField nameField = new JTextField();
     JLabel testLabel = new JLabel();
     BorderLayout borderLayout2 = new BorderLayout();

     public WaveServerGroupDialogPanel(WaveServerGroup group) {

          set(group);
     }

     public WaveServerGroupDialogPanel() {

            set (wsg);
     }

     /** Set the waveServer group to be shown in the panel. */
     public void set (WaveServerGroup group) {

          this.wsg = group;
          try  {
               jbInit();
          }
          catch(Exception e) {
               e.printStackTrace();
          }
     }

     /** Set the list of WaveServer groups that a new item would be added to
     from this panel */
     public void set (ActiveList list) {

            this.wsgList = list;
            repaint();
     }

     /** Build the panel */

     // This code is messy because it was partially generated by JBuilder GUI designer.
     private void jbInit() throws Exception {
          saveButton.setToolTipText("");
          saveButton.setText("SAVE");
          saveButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    saveButton_actionPerformed(e);
               }
          });
          this.setLayout(borderLayout1);
          resetlButton.setToolTipText("Return to initial values ");
          resetlButton.setText("RESET");
          resetlButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    resetlButton_actionPerformed(e);
               }
          });
          testButton.setToolTipText("Test connection to servers");
          testButton.setActionCommand("TEST");
          testButton.setText("TEST");
          testButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    testButton_actionPerformed(e);
               }
          });
          paramPanel.setLayout(gridLayout1);
          retryLabel.setToolTipText("Set maximum times server will be retried");
          retryLabel.setText("Maximum Retries");
          timeoutLable.setToolTipText("Set maximum time until server times out");
          timeoutLable.setText("Maximum timeout (sec)");

          retryField.setText(""+wsg.getMaxRetries());
          gridLayout1.setColumns(2);
          gridLayout1.setRows(0);
          timeoutField.setText(""+wsg.getMaxTimeoutMilliSecs()/1000);

          verifyCheck.setToolTipText("Check waveforms for errors");
          verifyCheck.setText("Verify Waveforms");
          verifyCheck.setSelected(wsg.isVerifyWaveforms());

          truncateCheck.setToolTipText("Truncate waveform at data gap");
          truncateCheck.setText("Truncate at gaps");
          truncateCheck.setSelected(wsg.isTruncateAtTimeGap());

          groupName.setText("Group Name");
          nameField.setText(wsg.getName());

          scrollPane.setToolTipText("Syntax> server.host.address:port");

	     listPanel.setBorder( new TitledBorder("server.host:port list") );
          listPanel.setLayout(borderLayout2);
//          listPanel.setMinimumSize(new Dimension(46, 150));
//          listPanel.setPreferredSize(new Dimension(26, 150));
//          this.setMinimumSize(new Dimension(256, 295));
//          this.setPreferredSize(new Dimension(256, 200));
          textArea.setPreferredSize(new Dimension(250, 125));
          testLabel.setText("Press [TEST] to check server(s)");
          this.setMinimumSize(new Dimension(276, 300));
          this.add(buttonPanel, BorderLayout.SOUTH);

          JPanel testPanel = new JPanel(new BorderLayout());
          testPanel.add(testButton, BorderLayout.WEST);
          testPanel.add(testLabel, BorderLayout.CENTER);

          buttonPanel.add(saveButton, null);
          buttonPanel.add(resetlButton, null);

          this.add(listPanel, BorderLayout.CENTER);
          listPanel.add(scrollPane, BorderLayout.CENTER);
          listPanel.add(testPanel, BorderLayout.SOUTH);

          scrollPane.getViewport().add(textArea, null);
          this.add(paramPanel, BorderLayout.NORTH);
          paramPanel.add(groupName, null);
          paramPanel.add(nameField, null);
          paramPanel.add(retryLabel, null);
          paramPanel.add(retryField, null);
          paramPanel.add(timeoutLable, null);
          paramPanel.add(timeoutField, null);
          paramPanel.add(verifyCheck, null);
          paramPanel.add(truncateCheck, null);

          textArea.setText(wsg.listToString());

     }

 /** Return a new WaveServerGroup as defined by the fields in this panel.
 * Returns null on error. */
     public WaveServerGroup getWaveServerGroup () {

            WaveServerGroup ws = new WaveServerGroup(nameField.getText());
            boolean status = false;

     // parse out the crap from the panel components
            int retries = Integer.parseInt(retryField.getText());
            ws.setMaxRetries(retries);

            int timeout = Integer.parseInt(timeoutField.getText());
            ws.setMaxTimeoutMilliSecs(timeout*1000);  // sec -> millis
            
            ws.setWaveformVerify(verifyCheck.isSelected());
            ws.setTruncatetAtTimeGap(truncateCheck.isSelected());

            // parse the list
            String delims = " :\t\n\r\f";   // only ":" is really used
            StringTokenizer strTok = new StringTokenizer(textArea.getText(), delims);

            // note the only syntax checking here is to catch the exception.
            // addServer() CHECKS THE CONNECTION AND WILL NOT ADD THE SERVER IF
            // IT DOES NOT RESPOND!
            try {
              while (strTok.hasMoreTokens()) {
                 status = ws.addServer(strTok.nextToken(), Integer.parseInt(strTok.nextToken()) );
              }
            } catch (Exception ex) {
              ex.printStackTrace();
              System.err.println("Bad syntax in list of server:port pairs");
              return null;
            }
            return ws;
     }
/**
 * Main for testing class
 * Note, needs:  import java.awt.event.*;
 */
    public static void main(String s[]) 
    {

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	{
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

	 
	//	JiggleProperties props = new JiggleProperties("properties");

     WaveServerGroup wsg = new WaveServerGroup("test");

          wsg.addServer ("spring.gps.caltech.edu", 6500);
          wsg.addServer ("spring.gps.caltech.edu", 6501);
          wsg.addServer ("jet.gps.caltech.edu", 6500);
          wsg.addServer ("jet.gps.caltech.edu", 6501);

     WaveServerGroupDialogPanel wsgp = new WaveServerGroupDialogPanel(wsg);

     frame.getContentPane().add(wsgp);

     
        frame.pack();
        frame.setVisible(true);

    }

    // Handle button actions
    
 /** Save the current server group and add it to the list */
     void saveButton_actionPerformed(ActionEvent e) {
     // make modifications permanent
       wsg = getWaveServerGroup();
       set(wsg);

       // add it to the list if there is one and its not already in it
       if (wsgList != null) {
         if (!wsgList.contains(wsg)) wsgList.add(wsg);
       }
     }

     /** tests the correctness of the current server group. Does not add it
     * to the list. */
     void testButton_actionPerformed(ActionEvent e) {

       wsg = getWaveServerGroup();    // this creates the WSG object
       set(wsg);

       System.out.println(wsg.toString());
       textArea.setText(wsg.listToString());

       if (wsg.listServers().length > 0) {
         testLabel.setText("Server connection OK");
       } else {
         testLabel.setText("Server connection OK");
       }

     }

     /** Reset to old settings */
     void resetlButton_actionPerformed(ActionEvent e) {

        set (wsg);
        return;
     }

}
