package org.trinet.jdbc;
import org.trinet.jdbc.datatypes.*;
import java.sql.*;

/** Class converts table column input data to SQL string syntax appropiate to build SQL statements. 
* @see NullValueDb
* @see org.trinet.jdbc.datatypes.DataObject
*/
public class StringSQL {

/** Returns String.valueOf(value) or returns "NULL", if NullValueDb.isNull(value). */
    public static String valueOf(int value) {
	return (NullValueDb.isNull(value)) ? "NULL" : String.valueOf(value);
    }

/** Returns String.valueOf(value) or returns "NULL", if NullValueDb.isNull(value). */
    public static String valueOf(long value) {
	return (NullValueDb.isNull(value)) ? "NULL" : String.valueOf(value);
    }

/** Returns String.valueOf(value) or returns "NULL", if NullValueDb.isNull(value). */
    public static String valueOf(float value) {
	return (NullValueDb.isNull(value)) ? "NULL" : String.valueOf(value);
    }

/** Returns String.valueOf(value) or returns "NULL", if NullValueDb.isNull(value). */
     public static String valueOf(double value) {
	return (NullValueDb.isNull(value)) ? "NULL" : String.valueOf(value);
    }

/** Returns String.valueOf(value.intValue()) or returns "NULL", if NullValueDb.isNull(value). */
    public static String valueOf(Integer value) {
	return (NullValueDb.isNull(value.intValue())) ? "NULL" : String.valueOf(value.intValue());
    }

/** Returns String.valueOf(value.longValue()) or returns "NULL", if NullValueDb.isNull(value). */
    public static String valueOf(Long value) {
	return (NullValueDb.isNull(value.longValue())) ? "NULL" : String.valueOf(value.longValue());
    }

/** Returns String.valueOf(value.floatValue()) or returns "NULL", if NullValueDb.isNull(value). */
    public static String valueOf(Float value) {
	return (NullValueDb.isNull(value.floatValue())) ? "NULL" : String.valueOf(value.floatValue());
    }

/** Returns String.valueOf(value.doubleValue()) or returns "NULL", if NullValueDb.isNull(value). */
    public static String valueOf(Double value) {
	return (NullValueDb.isNull(value.doubleValue())) ? "NULL" : String.valueOf(value.doubleValue());
    }

/** Returns "'value'" with blanks trimmed, or returns "NULL" if isBlank(value)==true. */
    public static String valueOf(String value) {
	return (NullValueDb.isBlank(value)) ? "NULL" : "'" + value.trim() + "'";
    }

/** Returns "'value'" with blanks trimmed, or returns "NULL"
*   if (isBlank(value)==true&&blankNull==true) || (isEmpty(value)&&blankNull==false).
*/
    public static String valueOf(String value, boolean blankNull) {
	if (blankNull) return valueOf(value);
	return (NullValueDb.isEmpty(value)) ? "NULL" : "'" + value.trim() + "'";
    }

/** Returns "'date-string-value'" or returns "NULL" if NullValueDb.isNull(value). */
    public static String valueOf(java.util.Date value) {
	if (NullValueDb.isNull(value)) return "NULL";
        String dateString = org.trinet.util.EpochTime.dateToString(value, "yyyy-MM-dd");
	return "'" + dateString + "'";
    }

/** Returns "'date-string-value'" or returns "NULL" if NullValueDb.isNull(value). */
    public static String valueOf(java.sql.Date value) {
	return (NullValueDb.isNull(value)) ? "NULL" : "'" + value.toString() + "'";
    }

/** Returns "'time-string-value'" or returns "NULL" if NullValueDb.isNull(value). */
    public static String valueOf(java.sql.Time value) {
	return (NullValueDb.isNull(value)) ? "NULL" : "'" + value.toString() + "'";
    }

/** Returns "'timestamp-string-value'" or returns "NULL" if NullValueDb.isNull(value). */
    public static String valueOf(java.sql.Timestamp value) {
	return (NullValueDb.isNull(value)) ? "NULL" : "'" + value.toString() + "'";
    }

/** Returns value.toStringSQL or returns "NULL" if NullValueDb.isNull(value). */
    public static String valueOf(DataObject value) {
	return (NullValueDb.isNull(value)) ? "NULL" : value.toStringSQL();
    }

/** Returns valueOf(value) from this object, else returns "'String.valueOf(value)'"
* or returns "NULL" if NullValueDb.isNull(value).
*/
    public static String valueOf(Object value) {
	if (NullValueDb.isNull(value)) return "NULL";
	if (value instanceof Integer) return valueOf((Integer) value);
	if (value instanceof Double) return valueOf((Double) value);
	if (value instanceof Float) return valueOf((Float) value);
	if (value instanceof Long) return valueOf((Long) value);
	if (value instanceof String) return valueOf((String) value);
	if (value instanceof java.sql.Date) return valueOf((java.sql.Date) value);
	if (value instanceof java.util.Date) return valueOf((java.util.Date) value);
	if (value instanceof Time) return valueOf((Time) value);
	if (value instanceof Timestamp) return valueOf((Timestamp) value);
	if (value instanceof DataObject) return valueOf((DataObject) value);
	return "'" + String.valueOf(value) + "'";
    }

/** Returns "NULL" if isBlank(value)==true, else returns the input value. */
    public static String EmptyToNULL(String value) {
	return (NullValueDb.isBlank(value)) ? "NULL" : value;
    }

/** Returns "NULL" if the input value == null, else returns the input value. */
    public static String NullToNULL(String value) {
	return (value == null) ? "NULL" : value;
    }

/** Returns "" if the input value == null, else returns the input value. */
    public static String NullToEmpty(String value) {
	return (value == null) ? "" : value;
    }
}
