// *** PACKAGE NAME *** \                                     
package org.trinet.jasi.EW.SQL;                                
                                                               
                                                               
// *** IMPORTS *** \                                          
import java.util.*;                                            
import java.sql.Connection;                                    
import java.sql.SQLException;                                  
import org.trinet.jasi.EW.EWWaveform;                                  
                                                               
                                                               
/**                                    
 * <!-- Class Description>             
 *                                     
 *                                     
 * Created:  2002/06/17                        
 *                                     
 * @author   ew_oci2java Tool / DK                        
 * @version  0.99                        
 **/                                   
                                       
public class GetWaveformListStatement extends EWSQLStatement 
{                                      
                                       
  // *** CLASS ATTRIBUTES *** \       
                                       
  // *** CONSTRUCTORS *** \           
  public GetWaveformListStatement()                          
  {                                    
    sSQLStatement = new String("select idWaveform, idChan, tStart, tEnd, iDataFormat, iByteLen from ALL_WAVES_W_COMPT_BY_EVENT where idEvent = :IN_idEvent");
    bIsQuery = true;                 
    init();                            
  }                                    
                                       
                                       
  public GetWaveformListStatement(Connection IN_conn)        
  {                                    
    this();                            
    SetConnection(IN_conn);            
  }                                    
                                       
                                       
  // *** CLASS METHODS *** \          
                                       
  protected boolean SetInputParams(Object obj)    
  {                                  
                                     
    EWWaveform objEWWaveform = (EWWaveform)obj;              
                                     
    try                              
    {                                
      cs.setLong(1, objEWWaveform.idEvent);    
    }                                
    catch (SQLException ex)          
    {                                
      System.err.println("Exception in GetWaveformListStatement:SetInputParams()"); 
      System.err.println(ex);        
      ex.printStackTrace();          
      return(false);                 
    }                                
                                     
    return(true);                    
  }   // end GetWaveformListStatement::SetInputParams()    
                                     
                                     
  protected boolean RetrieveOutputParamsList(Vector OutputObjectList) 
  {                                                      
                                                         
     EWWaveform objEWWaveform;                                           
                                                         
    try                              
    {                                
    while(rs.next())                                     
    {                                                    
      objEWWaveform = new EWWaveform();                                  
                                                         
      objEWWaveform.idWaveform=rs.getLong(1);                      
      objEWWaveform.idChan=rs.getLong(2);                      
      objEWWaveform.tStart=rs.getDouble(3);                      
      objEWWaveform.tEnd=rs.getDouble(4);                      
      objEWWaveform.iDataFormat=rs.getInt(5);                      
      objEWWaveform.iByteLen=rs.getInt(6);                      
      OutputObjectList.addElement(objEWWaveform);                
    }  // end while(rs.next)                             
    }                                
    catch (SQLException ex)          
    {                                
      System.err.println("Exception in GetWaveformListStatement:RetrieveOutputParamsList()"); 
      System.err.println(ex);        
      ex.printStackTrace();          
      return(false);                 
    }                                
                                                         
    return(true);                                        
  }   // end GetWaveformListStatement::RetrieveOutputParamsList()              
                                                         
                                                         
} // end class GetWaveformListStatement                      
                                       
                                       
//             <EOF>                   
