package org.trinet.apps;

import org.trinet.jiggle.*;
import java.util.*;
import java.io.*;

import org.trinet.util.WaveClient;
import org.trinet.jasi.*;
import org.trinet.util.BenchMark;
import org.trinet.util.magnitudeengines.SoCalML;

/**
   Stand-alone program for calculating the ML of one event using only the peak
   amps that are already associated with this event in the data source. It will
   NOT rescan waveforms for amps.<p>

   Usage: CalcML <evid> or CalcML <@filename> <p>

   If @filename is used the event ID's must be the first token on each line.
*/
public class CalcML {

      static boolean debug = false;
//      static boolean debug = true;
      static boolean doBM = false;

      static boolean fileMode = false;
      static String filename = "";

      static ArrayList eventList = new ArrayList();

     public CalcML() {
     }


    public static void main (String args[]) {

        BenchMark bm = new BenchMark();

  int evid = 0;

  if (args.length <= 0) {	// no args
    System.out.println
    ("Usage: CalcML <evid> or CalcML <@filename>");
    System.exit(0);
  }

  if (args.length > 0) {

    if (args[0].startsWith("@")) {
      fileMode = true;
      filename = args[0].substring(1);  // trim off the "@"

      eventList = readEventFile(filename);
    } else {
      fileMode = false;
      Integer val = Integer.valueOf(args[0]);
      eventList.add(val);
    }
    //evid = (int) val.intValue();
  }

     EnvironmentInfo.setApplicationName("CalcML");
     EnvironmentInfo.setNetworkCode("CI");
     // will mark data as "human" not automatic.
     EnvironmentInfo.setAutomatic(false);

        System.out.println ("Making connection...");
  DataSource init = new TestDataSource();  // make connection
  init.setWriteBackEnabled(true);
// ///////
  for (int i=0; i<eventList.size(); i++) {

     evid = (int) ((Integer)eventList.get(i)).intValue();

     if (debug) System.out.println("Processing: "+evid);

     if (debug) System.out.println ("Making MasterView for evid = "+evid);

  // Make the "superset" MasterView
  MasterView mv = new MasterView();

     // no wf's used
  mv.setWaveFormLoadMode(MasterView.LoadNone);

 //	mv.setTimeAlign(true);
     if (doBM) {
        bm.print("BenchMark: startup done ");
  bm.reset();
     }
  mv.defineByDataSource(evid);

     if (doBM) {
  bm.print("BenchMark: event parameters loaded ");
  bm.reset();
     }

  // get the first solution in the list
  //	Solution sol = (Solution) mv.solList.solList.get(0);
      Solution sol = null;
     if (mv.solList.size() > 0) {
     sol = (Solution) mv.solList.get(0);

        System.out.println ("SOL: "+sol.toString());
     System.out.println ("There are " + mv.getPhaseCount() +
          " phases, "+ mv.getWFViewCount() + " time series"+
                   " and "+mv.getAmpCount() + " amps");
     } else {
        System.out.println ("No dbase entry found for evid = "+evid);
        System.exit(0);
     }

     // load channel info
     if (sol.waveformList.size() > 100 &&
         MasterChannelList.isEmpty() ) {

       if (debug) System.out.println("Loading station info...");
       MasterChannelList.set(ChannelList.readCurrentList());
       bm.print("BenchMark: MasterChannelList loaded ");
       bm.reset();
     }

     /****************
      * Use CreateMagnitudeMethod() instead of SoCalML constructor.
      * Configuration Params are hardcoded in SoCalML.setDefaultParams()
      * Call ConfigureMagnitudeMethod() to setup method and default params.
      // ML
      SoCalML ml = new SoCalML();

     ml.setTrimResidual(1.0);
     ml.setMinSNR(8.0);    //per Kate Hutton 4/2002
     ml.setRequireCorrection(true);
     ml.setUseLowGains(false);
     **********************************/

  MagnitudeMethod ml = MagnitudeMethod.CreateMagnitudeMethod("org.trinet.util.magnitudeengines.SoCalML");
  ml.ConfigureMagnitudeMethod();

  MagnitudeEngine magEng = MagnitudeEngine.CreateMagnitudeEngine("org.trinet.util.magnitudeengines.LocalMagnitudeEngine");
  magEng.ConfigureMagnitudeEngine(ml);

     Magnitude newMag = magEng.solve(sol);

     if (newMag != null) sol.setPreferredMagnitude(newMag);

     // dump result
     System.out.println ("Amps in sol = "+sol.ampList.getAssociated(sol).size());
     System.out.println ("Amps in mag = "+sol.magnitude.ampList.size());
     System.out.println ("Total used  = "+sol.magnitude.getReadingsUsed());

     System.out.println (sol.ampList.toNeatString());
     System.out.println (sol.magnitude.neatDump());

     if (doBM) bm.print("BenchMark: ");
     System.out.println ("Total time = "+ bm.getSeconds() + " sec");

// You must commit the sol not just the mag, so that prefmag etc. gets set.

// set false for testing!!
     if (false) {
      try {
       sol.commit();
      } catch ( JasiCommitException ex) {}
     }

  } // end of loop

     System.exit(0);
    } // end of main

    /**
     * Read in list of evids
     * */
    static private ArrayList readEventFile(String filename) {
     ArrayList list = new ArrayList();
     String instr;
     String idstr;
      try{
  // Open the file
 //       FileInputStream fstream = new FileInputStream(filename);
  FileReader fr = new FileReader(filename);
  BufferedReader buff = new BufferedReader(fr);

  // Continue to read lines while there are still some left to read
        while ((instr = buff.readLine()) != null) {
         StringTokenizer tok = new StringTokenizer(instr);
         idstr = tok.nextToken(); // 1st token
         list.add(Integer.valueOf(idstr));
         if (debug) System.out.println("/"+idstr+"/");
      }

      fr.close();
    }
    catch (Exception e)
    {
      System.err.println("File input error");
    }
      return list;
    }

} // end of class
