	subroutine putrec2 (nsize, rec, ounit, istat)
c--Putrec collects ASCII records in a buffer, then writes them out when the
c  buffer is full.

	integer		nsize			
c				max number of records in buffer (presently 500)
	character*(*)	rec
c				record to be "written"
	integer		ounit			
c				output unit number
	integer		istat
c				-1 to initialize buffer
c				0 to grab a record
c				1 to write final buffer, dont add a new record
c	logical		lwrit
c				t if this call wrote out the buffer
	save		nrec			
c				total number of lines in buffer
	character*138	buf(500)
c				character buffer

c--Initialize (clear) buffer
	if (istat.lt.0) then
	  if (nsize.gt.500) then
	    print *,' Max size of record buffer is 500'
	    stop
	  end if
	  nrec = 0
c	  lwrit = .false.
	  return
	end if

c--Write out last buffer
	if (istat.gt.0) then
	  write (ounit) nrec, (buf(i),i=1,nrec)
c	  lwrit = .true.
	  return
	end if

c--Accumulate the record in the buffer
	nrec = nrec +1
	buf(nrec) = rec
c	lwrit = .false.

c--Write buffer out if its full
	if (nrec.eq.nsize) then
	  write (ounit) nrec, (buf(i),i=1,nrec)
c	  lwrit = .true.
	  nrec = 0
	end if
	return
	end
