      LOGICAL FUNCTION BOX3A (Y,X,Z,KLAS,NAME,FULNAM)
C--DETERMINES WHETHER A POINT IS IN THE REGION NUMBER KLAS.
C  CALLS THE SUBROUTINE BOX3.
C  ONLY ONE REGION IS TESTED. FOR NET 3 (New Hawaii)
C  THE REGION NUMBER NREGS+1 IS OUTSIDE ALL OF THE NREG REGIONS.  UNLIKE BOX3,
C  BOX3A WILL TEST THIS REGION BY EXCLUDING THE EVENT FROM ALL THE OTHER
C  REGIONS.

C--INPUTS:
C  Y     LATITUDE, DECIMAL DEGREES
C  X     LONGITUDE, DECIMAL DEGREES, POSITIVE EAST
C  Z     DEPTH, KM
C  KLAS  REGION NUMBER TO TEST

C--OUTPUTS:
C  BOX3A  TRUE IF POINT IS IN REGION OR ON EDGE, FALSE OTHERWISE
C  NAME  3-LETTER NAME FOR REGION IF INSIDE
C  FULNAM  THE FULL (25 CHAR. MAX) REGION NAME

      PARAMETER (NREGS=65)            !NUMBER OF DEFINED REGIONS
      CHARACTER NAME*3, FULNAM*25
      LOGICAL BOX3

      IF (KLAS .GT. NREGS) THEN
C--TEST ALL REGIONS.  IF EVENT IS NOT IN ANY IT IS IN REGION NREGS+1
        BOX3A=.FALSE.
        DO I=1,NREGS
          IF (BOX3 (Y,X,Z,I,NAME,FULNAM)) RETURN
        END DO
        BOX3A=.TRUE.
        NAME='DIS'
        FULNAM='Distant'

C--THE RESULT IS THAT FOR THE SINGLE REGION
      ELSE
        BOX3A = BOX3 (Y,X,Z,KLAS,NAME,FULNAM)
      END IF
      RETURN
      END
