
/*
 *   THIS FILE IS UNDER RCS - DO NOT MODIFY UNLESS YOU HAVE
 *   CHECKED IT OUT USING THE COMMAND CHECKOUT.
 *
 *    $Id: reaper.h,v 1.2 2004/09/09 19:29:23 davidk Exp $
 *
 *    Revision history:
 *
 */


#ifndef DB_CLEANUP_H
#define DB_CLEANUP_H

/* lengths of directory paths and names of things
*************************************************/
#define APP_MAXPATH 480
#define APP_MAXWORD 50
#define APP_MAXRULES 20
#define APP_MAX_RECORDS_TO_DELETE 1000

/* Error codes for db_cleanup: */
#define APP_SUCCESS                               0 
#define APP_WARNING                               1 
#define APP_ERROR_BAD_CONFIG_FILE                -1 
#define APP_ERROR_NOTHING_TO_CLEANUP             -2
#define APP_ERROR_EWDB_API_INIT_FAILED           -3
#define APP_ERROR_MALLOC_FAILED                  -4 
#define APP_ERROR_GETEVENTLIST_FAILED            -5
#define APP_ERROR_ARCHIVEEVENT_INIT_FAILED       -6 
#define APP_ERROR_ARCHIVEEVENT_FAILED            -7
#define APP_ERROR_DELETEEVENT_FAILED             -8
#define APP_ERROR_UNSUPPORTED_DELETEEVENT_MODE   -9
#define APP_ERROR_UNSUPPORTED_OTHER_DATA_MODE   -10
#define APP_ERROR_DELETE_DATA_FAILED            -11 
#define APP_ERROR_BAD_ARGUMENT_LIST             -12


/* Globals to set from configuration file
 ****************************************/
/* Database connection things */
extern char     DBuser[APP_MAXWORD];           /* UserId to connect to database as  */
extern char     DBpassword[APP_MAXWORD];       /* Password to datasource            */
extern char     DBservice[APP_MAXWORD];        /* DBMS instance to interact with    */

extern time_t tReckoning;

/* Misc vars */
extern time_t   tNow;  /* Current time at start of program */
extern int      DEBUG;
extern int      MaxEventsToHandle;

/* Function prototypes
 *********************/
int  ReadConfig( char * );					/* config.c, reads configuration file */
void logit_init( char *, short, int, int ); /* logit.c      sys-independent  */
void logit( char *, char *, ... );          /* logit.c      sys-independent  */

#endif DB_CLEANUP_H
