
/*
 *   THIS FILE IS UNDER RCS - DO NOT MODIFY UNLESS YOU HAVE
 *   CHECKED IT OUT USING THE COMMAND CHECKOUT.
 *
 *
 *    Revision history:
 *     $Log: startstop_lib.c,v $
 *     Revision 1.1  2006/04/04 18:00:14  stefan
 *     startstop with reconfigure and libraries 20060404 s.lisowski
 *
 *     Revision 1.0  2006/02/23 10:44:30  lisowski
 *     Initial revision. Removed common code from
 *	   system_control\startstop_nt\startstop.c and
 *	   system_control\startstop_service\startstop_service.c
 * 	   and put it here.
 *
 #	  return ERROR_FILE_NOT_FOUND; <- these are Microsoft #defined integers
 *
 */

/********************************************************************
 *                 startstop_lib.c for Windows 32, Linux, Solaris   *
 ********************************************************************/

#include <startstop_lib.h> /* Header for this .c file */


/******************************************************************
 *                         Heartbeat()                            *
 *          Send a heartbeat to a transport ring buffer           *
 ******************************************************************/
void Heartbeat( METARING *metaring )
{
   char           msg[20];
   static time_t  tlastbeat=0;
   time_t         now;
   unsigned short length;
   MSG_LOGO       logo;

   logo.instid = metaring->InstId;
   logo.mod    = metaring->MyModId;
   logo.type   = metaring->TypeHeartBeat;

   time( &now );
   if( (now - tlastbeat) < metaring->HeartbeatInt ) return;

   sprintf( msg, "%d\n\0", now );
   length = strlen( msg );

   if ( tport_putmsg( &(metaring->Region[0]), &logo, length, msg ) != PUT_OK )
      logit("t", "startstop: Error sending heartbeat to transport region: %s\n",
            metaring->ringName[0] );

   tlastbeat = now;
   return;
}

  /******************************************************************
   *                          GetCurrentUTC                         *
   *                                                                *
   *     Get the current UTC time as a 26 character string.         *
   ******************************************************************/

void GetCurrentUTC( char *timenow )
{
   time_t     now;
   struct tm  tstruct;

   time( &now );
   gmtime_ew( &now, &tstruct );
   asctime_ew( &tstruct, timenow, 26 );
   return;
}

/******************************************************************
 *                            ReportError()                       *
 *                                                                *
 *           Send error message to a transport ring buffer        *
 ******************************************************************/

void ReportError( 	int errNum,
					char *errStr,
					METARING *metaring)
{
   MSG_LOGO logo;
   unsigned short length;
   time_t tstamp;
   #ifdef _WINNT
	   char errMsg[100];
   #else
	   char errMsg[MAXLINE*2];
   #endif

   time( &tstamp );
   sprintf( errMsg, "%d %d %s\n\0", tstamp, errNum, errStr );

   logit("et","startstop: %s\n", errStr );

   logo.instid = metaring->InstId;
   logo.mod    = metaring->MyModId;
   logo.type   = metaring->TypeError;
   length      = strlen( errMsg );

   if ( tport_putmsg( &(metaring->Region[0]), &logo, length, errMsg ) != PUT_OK )
      logit("t", "startstop: Error sending error msg to transport region: %s\n",
               metaring->ringName[0] );
} /* end ReportError */


  /******************************************************************
   *                         StartError()                           *
   *                                                                *
   *               Report an error in starting a child              *
   ******************************************************************/

int StartError( int iChild, char *commandLine, METARING *metaring, int *nChild )
{
    char ErrText[512];
	char environmentScript[36];
#ifndef _WINNT /* this is probably Solaris or Linux  */
	int i;
	strcpy( environmentScript, "ew_linux.bash or ew_sol_sparc.cmd");
#else /* This is startstop NT or startstop service */
	strcpy( environmentScript, "ew_nt.cmd");
#endif

	logit("e","\nstartstop: **** FATAL ERROR ****\n" );
	sprintf( ErrText,"error starting <%s>", *commandLine );
	ReportError( ERR_STARTCHILD, ErrText, metaring );
	logit("e","\nTroubleshooting Tips:" );
	logit("e","\n------------------------------------------" );
	logit("e","\n\nEarthworm Program Errors:" );
	logit("e","\n1. Is the executable command %s spelled correctly?", commandLine );
	logit("e","\n\tTo correct this error, fix the command name in your %s file.\n", metaring->ConfigFile );
	logit("e","\n2. Are you running the Earthworm version you expected?" );
	logit("e","\n\tThese are your current Earthworm Environment Settings:" );
	logit("e","\n\t\tEW_HOME=%s", getenv("EW_HOME") );
	logit("e","\n\t\tEW_VERSION=%s", getenv("EW_VERSION") );
	logit("e","\n\t\tEW executable directory: %s/%s/bin",
		  getenv("EW_HOME"), getenv("EW_VERSION") );
	logit("e","\n\tTo Correct this error, Modify the above values in your %s file, or similar local file, to the ", environmentScript );
	logit("e","correct EW_HOME, EW_VERSION, or EW executable directory values.\n" );
	logit("e","\n3. Is the executable command %s in the Earthworm executable directory: %s\\%s\\bin? ",
		  commandLine, getenv("EW_HOME"), getenv("EW_VERSION") );
	logit("e","\n\tTo Correct this error, copy the above executable command to the Earthworm executable directory (listed above).\n" );
	logit("e","\n4. Is the Earthworm executable directory: %s/%s/bin in the PATH environment variable below?",
		  getenv("EW_HOME"), getenv("EW_VERSION") );
	logit("e","\n\tThese are your current paths:\n\t\tPATH=%s", getenv("PATH") );
	logit("e","\n\tTo Correct this error, Modify the set path line in your %s, or similar local file, to include ", environmentScript );
	logit("e","the Earthworm executable directory.\n" );
	logit("e","\n\nNon-Earthworm Program Errors:" );
	logit("e","\n1. Does the non-Earthworm executable exist in any directory listed in PATH (listed above)?" );
	logit("e","\n\tTo Correct this error, Modify the set path line in your %s file, or similar local file, to include ", environmentScript );
	logit("e","the path to the non-Earthworm executable.\n\n" );
	logit("e","\n------------------------------------------" );
	logit("e","\nstartstop: Exiting due to error starting <%s>\n", commandLine );
	*nChild = iChild; /*reset nChild to the number of live children*/

#ifndef _WINNT
	/* Send the kill flag to start Earthworm shutdown (Parent and other children) */
	for ( i = 0; i < metaring->nRing; i++ )
		tport_putflag( &(metaring->Region[i]), TERMINATE );

	/* Have this child exit */
	exit ( 1 );
#else
	return -1;
#endif


}
