/*
 *   THIS FILE IS UNDER RCS - DO NOT MODIFY UNLESS YOU HAVE
 *   CHECKED IT OUT USING THE COMMAND CHECKOUT.
 *
 *    $Id: local_earthworm_complex_funcs.h,v 1.1 2004/02/18 14:52:09 friberg Exp $
 *
 *    Revision history:
 *     $Log: local_earthworm_complex_funcs.h,v $
 *     Revision 1.1  2004/02/18 14:52:09  friberg
 *     Initial revision
 *
 *     Revision 1.1  2004/02/09 17:59:02  hal
 *
 *     [painting with a very broad brush here...]
 *
 *     * Added little endian port
 *     * Added q3302ew code
 *     * makefiles for linux
 *     * q3302ew makefile for windows
 *
 *     Revision 1.1  2001/04/06 21:03:30  davidk
 *     Initial revision
 *
 *
 ************************************************************/

#ifndef EARTHWORM_COMPLEX_FUNCS_H
# define EARTHWORM_COMPLEX_FUNCS_H

/* This file contains prototypes for earthworm libsrc
   functions that require special type definitions, such as
   (semaphores, threads, mutexes, sockets, etc.).

   If you have functions that only use primitive types and you
   do not need any extra header files for them to compile, then
   you can put them into earthworm_simple_funcs.h.

   Note, please try to keep functions from the same object
   together in one section of one file.  So all of the sema_ew.c
   stuff should go together.  Thank You!
   Davidk 2001/04/06
*************************************************************/

/* System-dependent stuff goes here
   ********************************/
#include <platform.h>

void CreateSemaphore_ew( void );            /* sema_ew.c    system-dependent */
void PostSemaphore   ( void );              /* sema_ew.c    system-dependent */
void WaitSemPost     ( void );              /* sema_ew.c    system-dependent */
void DestroySemaphore( void );              /* sema_ew.c    system-dependent */
void CreateMutex_ew  ( void );              /* sema_ew.c    system-dependent */
void RequestMutex( void );                  /* sema_ew.c    system-dependent */
void ReleaseMutex_ew( void );               /* sema_ew.c    system-dependent */
void CloseMutex( void );                    /* sema_ew.c    system-dependent */
void CreateSpecificMutex( mutex_t * );
void CloseSpecificMutex( mutex_t * );
void RequestSpecificMutex( mutex_t * );
void ReleaseSpecificMutex( mutex_t * );

                                            /* sendmail.c   system-dependent */
void SocketSysInit( void   );               /* socket_ew.c  system-dependent */
void SocketClose  ( int    );               /* socket_ew.c  system-dependent */
void SocketPerror ( char * );               /* socket_ew.c  system-dependent */
int sendall( int, const char *, long, int );/* socket_ew.c  system-dependent */

/* we don't use these, and C++ dislikes void * in this context */
int  WaitThread( unsigned * );              /* threads_ew.c system-dependent */
int  KillThread( unsigned int );            /* threads_ew.c system-dependent */
int  KillSelfThread( void );                /* threads_ew.c system-dependent */
#ifdef _WIN32
int  StartThread( void *, unsigned, unsigned * );
#else
int  StartThread( void*(*)(void*), unsigned, unsigned * );
#endif
int  StartThreadWithArg( void *, void *, unsigned, unsigned * );

#endif /* EARTHWORM_COMPLEX_FUNCS_H */
