
/*
 *   THIS FILE IS UNDER RCS - DO NOT MODIFY UNLESS YOU HAVE
 *   CHECKED IT OUT USING THE COMMAND CHECKOUT.
 *
 *    $Id: statrpt.c,v 1.2 2002/10/25 19:48:15 dietz Exp $
 *
 *    Revision history:
 *     $Log: statrpt.c,v $
 *     Revision 1.2  2002/10/25 19:48:15  dietz
 *     added #include <time.h>
 *
 *     Revision 1.1  2000/02/14 16:56:25  lucky
 *     Initial revision
 *
 *
 */

/*
 * statrpt.c: Produce an error or heartbeat message on the output ring.
 *              1) Construct the correct type of message.
 *              2) Send the message to the output ring.
 */

/*******                                                        *********/
/*      Functions defined in this source file                           */
/*******                                                        *********/

/*      Function: StatusReport                                          */
/*                                                                      */
/*      Inputs:         Pointer to the Network structure                */
/*                      Message type                                    */
/*                      Message id(code)                                */
/*                      Pointer to a string(message)                    */
/*                                                                      */
/*      Outputs:        Message structure sent to output ring           */
/*                                                                      */
/*      Returns:        Nothing                                         */

/*******                                                        *********/
/*      System Includes                                                 */
/*******                                                        *********/
#include <stdio.h>
#include <sys/types.h> /* time                                          */
#include <string.h>    /* strlen                                        */
#include <time.h>      /* time                                          */

/*******                                                        *********/
/*      Earthworm Includes                                              */
/*******                                                        *********/
#include <earthworm.h>  /* logit                                        */

/*******                                                        *********/
/*      Decimate Includes                                               */
/*******                                                        *********/
#include "decimate.h"

/*******                                                        *********/
/*      Function definitions                                            */
/*******                                                        *********/

/*      Function: SubtusReport                                          */
void StatusReport( WORLD* pDcm, unsigned char type, short code, 
                   char* message )
{
  char          outMsg[MAXMESSAGELEN];  /* The outgoing message.        */
  time_t        msgTime;        /* Time of the message.                 */

  /*  Get the time of the message                                     */
  time( &msgTime );

  /*  Build & process the message based on the type                   */
    if ( pDcm->dcmEWH.typeHeartbeat == type )
    {
      sprintf( outMsg, "%ld %ld\n\0", msgTime, pDcm->MyPid );
      
      /*Write the message to the output region                          */
      if ( tport_putmsg( &(pDcm->regionOut), &(pDcm->hrtLogo), 
                         (long) strlen( outMsg ), outMsg ) != PUT_OK )
      {
        /*     Log an error message                                    */
        logit( "et", "decimate: Failed to send a heartbeat message (%d).\n",
               code );
      }
    }
    else
    {
      if ( message ) {
        sprintf( outMsg, "%ld %hd %s\n\0", msgTime, code, message );
        logit("t","Error:%d (%s)\n", code, message );
      }
      else {
        sprintf( outMsg, "%ld %hd\n\0", msgTime, code );
        logit("t","Error:%d (No description)\n", code );
      }

      /*Write the message to the output region                         */
      if ( tport_putmsg( &(pDcm->regionOut), &(pDcm->errLogo), 
                         (long) strlen( outMsg ), outMsg ) != PUT_OK )
      {
        /*     Log an error message                                    */
        logit( "et", "decimate: Failed to send an error message (%d).\n",
               code );
      }
      
    }
}


