#
# q2ew - quanterra to earthworm interface
#


CFLAGS = -D_REENTRANT ${GLOBALFLAGS}

B = $(EW_HOME)/$(EW_VERSION)/bin
L = $(EW_HOME)/$(EW_VERSION)/lib

QLIB_DIR = ./qlib2
COMSERV_INC = ./comserv/include
COMSERV_LIB = ./comserv/util

CFLAGS += -xCC -I$(QLIB_DIR) -I$(COMSERV_INC)

all: qlib2 comserv q2ew

qlib2:  FORCE
	@echo "Making qlib2"
	cd qlib2; make

comserv:  FORCE
	@echo "Making comserv"
	cd comserv; make; make install

SRCS = convert.c getconfig.c main.c scn_map.c cs_status.c \
	heart.c misc_seed_utils.c die.c logo.c options.c

OBJS = convert.o getconfig.o main.o scn_map.o cs_status.o \
	heart.o misc_seed_utils.o die.o logo.o options.o
 
EW_LIBS = \
	$L/getutil.o \
	$L/kom.o \
	$L/logit_mt.o \
	$L/sema_ew.o \
	$L/threads_ew.o \
	$L/time_ew.o \
	$L/sleep_ew.o \
	$L/transport.o

q2ew: $(OBJS); \
        cc -o $(B)/q2ew $(OBJS) $(EW_LIBS) -L$(QLIB_DIR) -L$(COMSERV_LIB) -lqlib2 -lutil -lsocket -lnsl -lposix4 -lthread -lm

# Clean-up rules
clean:
	rm -f a.out core *.o *.obj *% *~
	(cd comserv; make clean)
	(cd qlib2; make clean)

clean_bin:
	rm -f $B/q2ew*

FORCE:
