/*
 *   This file is managed using Concurrent Versions System (CVS).
 *
 *    $Id: to_pick2k.c,v 1.5 2004/10/19 21:54:04 lombard Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


      /*******************************************************
       *                    to_pick_2k()                     *
       *  Convert a pick of TYPE_PICK_SCNL to a pick of      *
       *  TYPE_PICK2K.                                       *
       *******************************************************/


int to_pick2k( char *pick_scnl, char *pick2k, unsigned char newMsgType )
{
   char *ptr;
   char ps[120];
   char modId[4];
   char instId[4];
   char pickIndex[5];
   char sta[6];
   char chan[4];
   char net[3];
   char pd[3];            /* Pick descriptor */
   char dateTime[19];
   char xpk1[9], xpk2[9], xpk3[9];
   char firstMotion;
   char quality;

   strncpy( ps, pick_scnl, 120 );  ps[119] = '\0';

   if ( (ptr = strtok( ps, " " )) == NULL ) return -1;  /* Skip msg type field */

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( modId, ptr, 3 ); modId[3] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( instId, ptr, 3 ); instId[3] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( pickIndex, ptr, 4 ); pickIndex[4] = '\0';

   if ( (ptr = strtok( NULL, "." )) == NULL ) return -1;
   strncpy( sta, ptr, 5 ); sta[5] = '\0';

   if ( (ptr = strtok( NULL, "." )) == NULL ) return -1;
   strncpy( chan, ptr, 3 ); chan[3] = '\0';

   if ( (ptr = strtok( NULL, "." )) == NULL ) return -1;
   strncpy( net, ptr, 2 ); net[2] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;  /* Skip loc code field */

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( pd, ptr, 2 ); pd[2] = '\0';
   firstMotion = (strlen(pd) == 2) ? pd[0] : ' ';
   if( firstMotion == '?' ) firstMotion = ' ';            /* convert '?' to ' ' */
   quality     = (strlen(pd) == 1) ? pd[0] : pd[1];

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;  /* I cheated and just */
   strncpy( dateTime, ptr, 18 ); dateTime[17] = '\0';     /* lopped off milliseconds */

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( xpk1, ptr, 8 ); xpk1[8] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( xpk2, ptr, 8 ); xpk2[8] = '\0';

   if ( (ptr = strtok( NULL, "\n" )) == NULL ) return -1;
   strncpy( xpk3, ptr, 8 ); xpk3[8] = '\0';

   sprintf( pick2k,    "%3d",   (int)newMsgType );
   sprintf( pick2k+3,  "%3s",   modId );
   sprintf( pick2k+6,  "%3s ",  instId );
   sprintf( pick2k+10, "%4s ",  pickIndex );
   sprintf( pick2k+15, "%-5s",  sta );
   sprintf( pick2k+20, "%-2s",  net );
   sprintf( pick2k+22, "%-3s",  chan );
   sprintf( pick2k+25, " %c ",  firstMotion );
   sprintf( pick2k+27, "%c  ",  quality );
   sprintf( pick2k+30, "%17s",  dateTime );
   sprintf( pick2k+47, "%8s",   xpk1 );
   sprintf( pick2k+55, "%8s",   xpk2 );
   sprintf( pick2k+63, "%8s\n", xpk3 );
   return 0;
}
