/*
 *   This file is managed using Concurrent Versions System (CVS).
 *
 *    $Id: to_coda2k.c,v 1.4 2004/10/19 21:54:04 lombard Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


      /*******************************************************
       *                     to_coda2k()                     *
       *  Convert a coda of TYPE_CODA_SCNL to a coda of      *
       *  TYPE_CODA2K.                                       *
       *******************************************************/


int to_coda2k( char *coda_scnl, char *coda2k, unsigned char newMsgType )
{
   char *ptr;
   char cs[120];
   char modId[4];
   char instId[4];
   char pickIndex[5];
   char sta[6];
   char chan[4];
   char net[3];
   char aav1[9], aav2[9], aav3[9], aav4[9], aav5[9], aav6[9];
   char codaDur[5];

   strncpy( cs, coda_scnl, 120 );  cs[119] = '\0';

   if ( (ptr = strtok( cs, " " )) == NULL ) return -1;  /* Skip msg type field */

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( modId, ptr, 3 ); modId[3] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( instId, ptr, 3 ); instId[3] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( pickIndex, ptr, 4 ); pickIndex[4] = '\0';

   if ( (ptr = strtok( NULL, "." )) == NULL ) return -1;
   strncpy( sta, ptr, 5 ); sta[5] = '\0';

   if ( (ptr = strtok( NULL, "." )) == NULL ) return -1;
   strncpy( chan, ptr, 3 ); chan[3] = '\0';

   if ( (ptr = strtok( NULL, "." )) == NULL ) return -1;
   strncpy( net, ptr, 2 ); net[2] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;  /* Skip loc code field */

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( aav1, ptr, 8 ); aav1[8] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( aav2, ptr, 8 ); aav2[8] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( aav3, ptr, 8 ); aav3[8] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( aav4, ptr, 8 ); aav4[8] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( aav5, ptr, 8 ); aav5[8] = '\0';

   if ( (ptr = strtok( NULL, " " )) == NULL ) return -1;
   strncpy( aav6, ptr, 8 ); aav6[8] = '\0';

   if ( (ptr = strtok( NULL, "\n" )) == NULL ) return -1;
   strncpy( codaDur, ptr, 4 ); codaDur[4] = '\0';

   sprintf( coda2k,    "%3d",   (int)newMsgType );
   sprintf( coda2k+3,  "%3s",   modId );
   sprintf( coda2k+6,  "%3s ",  instId );
   sprintf( coda2k+10, "%4s ",  pickIndex );
   sprintf( coda2k+15, "%-5s",  sta );
   sprintf( coda2k+20, "%-2s",  net );
   sprintf( coda2k+22, "%-3s",  chan );
   sprintf( coda2k+25, "%8s",   aav1 );
   sprintf( coda2k+33, "%8s",   aav2 );
   sprintf( coda2k+41, "%8s",   aav3 );
   sprintf( coda2k+49, "%8s",   aav4 );
   sprintf( coda2k+57, "%8s",   aav5 );
   sprintf( coda2k+65, "%8s",   aav6 );
   sprintf( coda2k+73, "%4s \n", codaDur );
   return 0;
}
