package org.trinet.util.magnitudeengines;

/** To calculate time series amplitude coda decay data and get results in a CodaTN object. */
public class McaCodaGeneratorExp extends McaCodaGeneratorTN {

    public McaCodaGeneratorExp () {
        super();
    }

    protected double getWindowStartingSampleSecsOffset(int windowCount) {
        if (windowCount < 6)  return  2.0  * windowCount;
        if (windowCount < 14) return  5.0  * (windowCount - 3);
        if (windowCount < 21) return 10.0  * (windowCount - 8);
        return 20.0 * (windowCount - 14);
    }

    protected double getWindowTauSeconds(int windowCount) {
        return secsPastPTimeAtStartingIdx + getWindowStartingSampleSecsOffset(windowCount) + windowSize;
    }

/*
    public static final void main( String args [] ) {
        McaCodaGeneratorExp mc = new McaCodaGeneratorExp();
        mc.secsPerSample = .01;
        for (int idx = 0; idx < 20; idx++) {
            System.out.println("sample idx: " + mc.getWindowStartingSampleIndexOffset(idx)) ;
        }
        mc = null;
        System.exit(0);
    }
*/

}
