package org.trinet.util.graphics.table;
import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;
import java.math.*;
import org.trinet.jdbc.datatypes.*;
import org.trinet.util.*;
public class DateTimeEditor extends AbstractCellEditor {
  int fontSize=12;
  Font font;
  JTextField component;

  public DateTimeEditor() { 
    super();
    font = new Font("Monospaced", Font.PLAIN, fontSize);
    component = new JTextField();
    component.addActionListener(this);
  }
  
  public DateTimeEditor(int fontSize) { 
    super();
    if (fontSize > 0) this.fontSize = fontSize;
    font = new Font("Monospaced", Font.PLAIN, fontSize);
    component = new JTextField();
    component.addActionListener(this);
  }
  
  public DateTimeEditor(Font font) { 
    super();
    if (font != null) this.font = font;
    else this.font = new Font("Monospaced", Font.PLAIN, fontSize);
    component = new JTextField();
    component.addActionListener(this);
  }
  
  public int getFontSize() {
    return fontSize;
  }

  public void setFontSize(int fontSize) {
    if (fontSize > 0) this.fontSize = fontSize;
    font = font.deriveFont((float) fontSize);
  }

// Methods to implement DefaultCellEditor 
  public boolean startCellEditing(EventObject anEvent) {
    if(anEvent == null) component.requestFocus();
    else if (anEvent instanceof MouseEvent) {
      if (((MouseEvent)anEvent).getClickCount() < clickCountToStart)
        return false;
    }
    return true;
  }
  public Component getComponent() {
    return this.component;
  }

  public Object getCellEditorValue() {
    return new Double(EpochTime.stringToEpoch(component.getText()));
  }

  public void setCellEditorValue(Object value) {
//    if (value != null) component.setText(EpochTime.epochToString(((BigDecimal) value).doubleValue()).substring(0,24));
    if (value != null) {
	if (value instanceof Number) {
	    component.setText(EpochTime.epochToString(((Number) value).doubleValue()).substring(0,24));
	}
	else if (value instanceof DataObject) {
	    component.setText(EpochTime.epochToString(((DataObject) value).doubleValue()).substring(0,24));
	}
	else if (value instanceof String) {
	    component.setText((String) value);
	}
    }
    else component.setText("");
    this.value = value;
  }

  public Component getTableCellEditorComponent( JTable table, Object value,
		boolean isSelected,int row,int column) {
    component = new JTextField(14);
    component.setFont(font);
    component.setHorizontalAlignment(JTextField.RIGHT);
    setCellEditorValue(value);
    return component;
  }
}
