package org.trinet.util.graphics.table;
import org.trinet.jasi.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.util.Arrays;
import org.trinet.util.*;

public class CatalogTable {
    private JTable  tableRowHead;
    private JTable  tableView;
    private CatalogTableModel tableModel;
    private TableSorterAbs  sorter;
    private JScrollPane  tableDB;
    private Font font;
    private int fontSize = 12;
    private final static String [] DEFAULT_NAME_ORDER = CatalogTableConstants.columnNames;
    private String [] columnNameOrder = DEFAULT_NAME_ORDER;

    public final void setColumnNameOrder(String [] names) {
       if (names != null) columnNameOrder = names;
    }
    public final String [] getColumnNameOrder() {
        return columnNameOrder;
    }

    static final int MAX_FRACTION_ELEMENTS=16;
    static final int COLUMN_WIDTH_PADDING=2;

// Table constructor
    public CatalogTable(CatalogTableModel tm) {
        this.tableModel = tm;
    }

    public String [] getTableColumnHeaders() {
        if (tableView == null) return null;
        int count = tableView.getColumnCount();
        if (count < 1) return null;
        String [] headers = new String[count];
        TableColumnModel tcm = tableView.getColumnModel();
        for (int i = 0; i < count; i++) {
            headers[i] = (String) tcm.getColumn(i).getHeaderValue();
        }
        return headers;
    }

    public int getSortedRowModelIndex(int selectedRow) {
        return sorter.indexes[selectedRow];
    }

    public TableSorterAbs getSortedModel() {
        return sorter;
    }

    public CatalogTableModel getModel() {
	return this.tableModel;
    }

    public JTable getRowHeader() {
	return tableRowHead;
    }

    public JTable getTable() {
	return tableView;
    }

    private final class TableHeaderRenderer extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected, boolean hasFocus, int row, int column) {
            if (table != null) {
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    setForeground(header.getForeground());
                    setBackground(header.getBackground());
                    setFont(header.getFont());
                }
            }

            setText((value == null) ? "" : value.toString());
//            setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            setBorder(BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
            setHorizontalAlignment(JLabel.CENTER);
            return this;
        }
    }

// Implementation of Listener interface
    public class EditorMouseListener extends MouseAdapter {
        public void mousePressed(MouseEvent evt) {
            if ( evt.getModifiers() == MouseEvent.BUTTON3_MASK && evt.getClickCount() == 2) {
//                Debug.println("CatalogTable: EML Canceling edit");
                tableView.editingCanceled(new ChangeEvent(tableView));
                tableView.repaint();
            }
            else if ( evt.getModifiers() == MouseEvent.BUTTON2_MASK && evt.getClickCount() == 2) { 
//                Debug.println("CatalogTable: EML Stopping edit");
                tableView.editingStopped(new ChangeEvent(tableView));
//                tableView.repaint();
            }
        }
    }

    class TableEditListener implements ListSelectionListener {
      public void valueChanged(ListSelectionEvent e) {
/*
        Object obj = e.getSource();
//        Debug.println("CatalogTable: TableEditListener Source: " + e.getSource() );
        Component [] cmps = tableView.getComponents();
        for (int i  = 0; i<cmps.length; i++) {
//            Debug.println(cmps[i].getClass().getName());
            Component [] cmps2 = ((CellRendererPane)cmps[i]).getComponents();
            for (int j  = 0; j<cmps2.length; j++) {
//                Debug.println(cmps2[i].getClass().getName());
            }
        }
*/
//        if (tableView.isEditing()) tableView.editingCanceled(new ChangeEvent(tableView));
        if (tableView.isEditing()) tableView.editingStopped(new ChangeEvent(tableView));
      }
    }

    class TableRowHeadSelectionListener implements ListSelectionListener {
      public void valueChanged(ListSelectionEvent e) {
	if (tableRowHead.getSelectedRowCount() <= 0) return;
	int [] rows = tableRowHead.getSelectedRows();
        tableView.clearSelection(); 
	for (int index=0; index<rows.length; index++) {
	    tableView.addRowSelectionInterval(rows[index], rows[index]);
	}
      }
    }

    class TableViewSelectionListener implements ListSelectionListener {
      public void valueChanged(ListSelectionEvent e) {
	if (tableView.getSelectedRowCount() <= 0) return;
        int irow = tableView.getSelectedRow();
        int irow2 = tableRowHead.getSelectedRow(); // need to check for equivalence else race ValueChanged event loop.
        if (irow != irow2 && irow >= 0) {
            tableRowHead.clearSelection(); 
            tableRowHead.setRowSelectionInterval(irow, irow); 
        }
      }
    }

    public JScrollPane createTable(AbstractTableModel tableModel) {
      this.tableModel = (CatalogTableModel) tableModel;
      return createTable();
    }

    public JScrollPane createTable() {
//        Debug.println("CatalogTable setting up MainTable JTable scrollpane ...");
        sorter = new TableSorterAbs();
        sorter.setModel(tableModel);
        tableView = new JTable(sorter);
        if (font == null) font = new Font("Monospaced", Font.PLAIN, fontSize);
        tableView.setFont(font);
        tableView.setShowGrid(true);
        tableView.setAutoResizeMode(tableView.AUTO_RESIZE_OFF );
//      tableView.setToolTipText("double-click edits data field only if SELECT FOR UPDATE query");

//        tableView.sizeColumnsToFit(tableView.AUTO_RESIZE_NEXT_COLUMN );
//        tableView.getTableHeader().setUpdateTableInRealTime(false);
        tableView.getTableHeader().setForeground(Color.red);
        tableView.getTableHeader().setBackground(new Color(.85f,.85f,.85f));
        tableView.getTableHeader().setToolTipText("dbl-click sort ascend; shift-dbl-click sort descend");
        tableView.getTableHeader().setFont(font);

//        JScrollPane scrollpane = new JScrollPane(tableView);

// Make second table for row header
//        Debug.println("CatalogTable setting up RowHeader JTable scrollpane ...");
        TableColumnModel tcm = tableView.getColumnModel();
        TableColumnModel tcm2 = new DefaultTableColumnModel();
        int nkeyCols = 0;
        TableColumn col;
        int maxCol = tableModel.getColumnCount();
        for (int i = 0; i < maxCol; i++) {
            if (tableModel.isKeyColumn(i)) {
                col = tcm.getColumn(tcm.getColumnIndex((Object) tableModel.getColumnName(i)));
                tcm.removeColumn(col);
                tcm2.addColumn(col);
                nkeyCols++;
            }
// test of limited column view AWW 11/99
	    if (tableModel.isColumnHidden(i))
                tcm.removeColumn(tcm.getColumn(tcm.getColumnIndex((Object) tableModel.getColumnName(i))));
        }
	tcm.moveColumn(tcm.getColumnIndex((Object) "MAG"), 4);
//
// test to change column order here?
        TableColumnModel tcmTmp = new DefaultTableColumnModel();
        maxCol = columnNameOrder.length; 
        for (int i = 0; i < maxCol; i++) {
            String colName = columnNameOrder[i];
            try {
                tcmTmp.addColumn(tableView.getColumn(colName));
            }
            catch (IllegalArgumentException ex) {
                System.out.println("Check column order by name - No such table column name:" + colName);
            }
        }
        tableView.setColumnModel(tcmTmp);
        tcm = tcmTmp;
// end of test
        tableRowHead = new JTable(sorter); 
        tableRowHead.setColumnModel(tcm2);
        tableRowHead.setFont(font);
        tableRowHead.setShowGrid(true);
        tableRowHead.setAutoResizeMode( tableRowHead.AUTO_RESIZE_OFF );

//        tableRowHead.sizeColumnsToFit(tableRowHead.AUTO_RESIZE_NEXT_COLUMN );
//        tableRowHead.getTableHeader().setUpdateTableInRealTime(false);
        tableRowHead.getTableHeader().setForeground(Color.red);
        tableRowHead.getTableHeader().setBackground(new Color(.85f,.85f,.85f));
        tableRowHead.getTableHeader().setFont(font);
        tableRowHead.getTableHeader().setToolTipText("dbl-click sort ascend; shift-dbl-click sort descend");
        
// Setup format patterns and number renderers
        FormattedNumberRenderer [] numberRenderer = new FormattedNumberRenderer [MAX_FRACTION_ELEMENTS];
        FormattedNumberEditor_FW [] numberEditor = new FormattedNumberEditor_FW [MAX_FRACTION_ELEMENTS];
        String pattern;                   // format pattern buffer
        String pattern9 = "#0.000000"; // generic four byte float
        FormattedNumberRenderer numberRenderer9 = new FormattedNumberRenderer(pattern9);
        FormattedNumberEditor_FW numberEditor9 = new FormattedNumberEditor_FW(pattern9);
        numberEditor9.getComponent().addMouseListener(new EditorMouseListener());

// Assign editor/renderers to table columns        
// comment out for rendering test aww
        for (int i = 0; i<tableView.getColumnCount(); i++) {
          TableColumn tc = tcm.getColumn(i);
          tc.setHeaderRenderer(new TableHeaderRenderer());
          Class tmpclass = tableView.getColumnClass(i);
//	  Debug.println("CatalogTable tableView getColumnClass (i)" + i + " " + tmpclass.getName());
          if (tmpclass.getName().indexOf("String") >= 0) {
                  tc.setCellRenderer(new TextCellRenderer(font));
                  TextCellEditor textEditor = new TextCellEditor(font);
                  textEditor.getComponent().addMouseListener(new EditorMouseListener());
                  tc.setCellEditor(textEditor);
          }
          else if (tmpclass.getName().indexOf("Double") >= 0) {
                  int indexViewToModel = tableView.convertColumnIndexToModel(i);
                  int fractionWidth = tableModel.getColumnFractionDigits(indexViewToModel);
                  if (fractionWidth >= 0) {
                    if (fractionWidth > MAX_FRACTION_ELEMENTS - 1 ) fractionWidth = MAX_FRACTION_ELEMENTS - 1;
                    pattern = getNumberFormatPattern(fractionWidth);
                    if (numberRenderer[fractionWidth] == null) 
                      numberRenderer[fractionWidth] = new FormattedNumberRenderer(pattern);
                    if (numberEditor[fractionWidth] == null) { 
                          numberEditor[fractionWidth] = new FormattedNumberEditor_FW(pattern);
                        numberEditor[fractionWidth].getComponent().addMouseListener(new EditorMouseListener());
                    }
                    tc.setCellEditor(numberEditor[fractionWidth]);
                    tc.setCellRenderer(numberRenderer[fractionWidth]);
                  }
                  else if (fractionWidth < 0 ) {
                    tc.setCellEditor(numberEditor9);
                    tc.setCellRenderer(numberRenderer9);
                  }
          }
          else if (tmpclass.getName().indexOf("Long") >= 0 || tmpclass.getName().indexOf("Integer") >= 0 ||
                tmpclass.getName().indexOf("Number") >= 0 ) {
                  pattern = getNumberFormatPattern(0);
                  if (numberRenderer[0] == null) numberRenderer[0] = new FormattedNumberRenderer(pattern);
                  if (numberEditor[0] == null) {
                        numberEditor[0] = new FormattedNumberEditor_FW(pattern);
                        numberEditor[0].getComponent().addMouseListener(new EditorMouseListener());
                  }
                  tc.setCellEditor(numberEditor[0]);
                  tc.setCellRenderer(numberRenderer[0]);
          }
        }

        CalendarDateRenderer cdRenderer = new CalendarDateRenderer();
        cdRenderer.setHorizontalAlignment(JLabel.LEFT);
        tableView.setDefaultRenderer(java.sql.Date.class, cdRenderer);
        DateTimeEditor dtEditor = new DateTimeEditor(font);
        dtEditor.getComponent().addMouseListener(new EditorMouseListener());
        DateTimeRenderer dtRenderer = new DateTimeRenderer();
        dtRenderer.setHorizontalAlignment(JLabel.LEFT);
        
        for (int i = 0; i<tableView.getColumnCount(); i++) {
//        Debug.println("CatalogTable tableView getColumnName (i)" + i + " " + tableView.getColumnName(i));
          if (tableView.getColumnName(i).equalsIgnoreCase("datetime")) {
                TableColumn tc = tcm.getColumn(i);
                tc.setCellRenderer(dtRenderer);
                tc.setCellEditor(dtEditor);
          }
        }
//comment out for test of rendering
// size scrollable main table columns
//        Debug.println("CatalogTable sizing MainTable columns");        
        initColumnSizes(tableView);

// setup main table selection/color attributes
        tableView.setCellSelectionEnabled(false);
        tableView.setRowSelectionAllowed(true);
        tableView.setColumnSelectionAllowed(false);
        tableView.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        tableView.setForeground(Color.black);
        tableView.setBackground(new Color(1.f,1.f,0.7f));
        tableView.setSelectionForeground(Color.red);
        tableView.setSelectionBackground(Color.white);

// assign rowheader renderer (string type)
//        Debug.println("CatalogTable setting up RowHeader cell renderers/editors...");

        for (int i = 0; i<tableRowHead.getColumnCount(); i++) {
          TableColumn tc = tcm2.getColumn(i);
          tc.setHeaderRenderer(new TableHeaderRenderer());

          Class tmpclass = tableRowHead.getColumnClass(i);
          if (tmpclass.getName().equals("java.lang.String")) {
                  tc.setCellRenderer(new TextCellRenderer(font));
                  TextCellEditor textEditor = new TextCellEditor(font);
                  textEditor.getComponent().addMouseListener(new EditorMouseListener());
                  tc.setCellEditor(textEditor);
          }
          else if (tmpclass.getName().equals("java.lang.Double")) {
                  int indexViewToModel = tableRowHead.convertColumnIndexToModel(i);
                  int fractionWidth = tableModel.getColumnFractionDigits(indexViewToModel);
                  if (fractionWidth >= 0) {
                    if (fractionWidth > MAX_FRACTION_ELEMENTS - 1 ) fractionWidth = MAX_FRACTION_ELEMENTS - 1;
                    pattern = getNumberFormatPattern(fractionWidth);
                    if (numberRenderer[fractionWidth] == null) 
                      numberRenderer[fractionWidth] = new FormattedNumberRenderer(pattern);
                    if (numberEditor[fractionWidth] == null) { 
                      numberEditor[fractionWidth] = new FormattedNumberEditor_FW(pattern);
                      numberEditor[fractionWidth].getComponent().addMouseListener(new EditorMouseListener());
                    }
                    tc.setCellEditor(numberEditor[fractionWidth]);
                    tc.setCellRenderer(numberRenderer[fractionWidth]);
                  }
                  else if (fractionWidth < 0 ) {
                    tc.setCellEditor(numberEditor9);
                    tc.setCellRenderer(numberRenderer9);
                  }
          }
          else if (tmpclass.getName().equals("java.lang.Integer") || tmpclass.getName().equals("java.lang.Number") ||
                tmpclass.getName().equals("java.lang.Long") ) {
                  pattern = getNumberFormatPattern(0);
                  if (numberRenderer[0] == null) numberRenderer[0] = new FormattedNumberRenderer(pattern);
                  if (numberEditor[0] == null) {
                    numberEditor[0] = new FormattedNumberEditor_FW(pattern);
                    numberEditor[0].getComponent().addMouseListener(new EditorMouseListener());
                  }
                  tc.setCellEditor(numberEditor[0]);
                  tc.setCellRenderer(numberRenderer[0]);
//                  tc.setCellEditor(numberEditor7);
//                  tc.setCellRenderer(numberRenderer7);
          }
        }

        for (int i = 0; i<tableRowHead.getColumnCount(); i++) {
	    String name = tableRowHead.getColumnName(i);
            if (name.equalsIgnoreCase("datetime")) {
                TableColumn tc = tcm2.getColumn(i);
                tc.setCellRenderer(dtRenderer);
                tc.setCellEditor(dtEditor);
            }
// implemented code below as an example of renderering "deleted" solution ids differently.
	    else if (name.equalsIgnoreCase("id")) {
		DeletedRowCellNumberRenderer render = new DeletedRowCellNumberRenderer(tableModel);
		render.setDefaultBackgroundColor(Color.yellow);
                tcm2.getColumn(i).setCellRenderer(render);
	    }
        }
        tableRowHead.setDefaultRenderer(java.sql.Date.class, cdRenderer);
// end of renderer removal test aww
// size rowheader columns
//        Debug.println("CatalogTable sizing RowHead columns");        
        initColumnSizes(tableRowHead);

//        Debug.println("CatalogTable finished with renderer setup; final table setup");        
// setup rowheader selection/color attributes
        tableRowHead.setCellSelectionEnabled(false);
        tableRowHead.setRowSelectionAllowed(true);
        tableRowHead.setColumnSelectionAllowed(false);
        tableRowHead.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        tableRowHead.setForeground(Color.black);
        tableRowHead.setBackground(Color.yellow);
        tableRowHead.setSelectionForeground(Color.blue);
        tableRowHead.setSelectionBackground(Color.orange);
//      tableRowHead.setToolTipText("Key fields highlighted yellow (shift-click over cell resizes rowheader width)");

// size rowheader and put in scrollpane
        JScrollPane scrollpane = null;
        tableRowHead.setPreferredScrollableViewportSize(tableRowHead.getPreferredSize());
        if (tableView.getColumnCount() <= 0) {
          System.out.println("CatalogTable: tableView has no columns");
          scrollpane = new JScrollPane(tableRowHead);
        }
        else scrollpane = new JScrollPane(tableView);
        scrollpane.setRowHeaderView(tableRowHead);
        scrollpane.setCorner(JScrollPane.UPPER_LEFT_CORNER, tableRowHead.getTableHeader());

// add main table models event listeners
        tcm2.addColumnModelListener(tableView);
//        tcm2.getSelectionModel().addListSelectionListener(new TableEditListener());
//        tcm.getSelectionModel().addListSelectionListener(new TableEditListener());
        sorter.addTableModelListener(tableView);
        sorter.addMouseListenerToHeaderInTable(tableView); // Install a mouse listener in the TableHeader as the sorter UI.
// sync rowheader selection with main table cell selection
        tableView.getSelectionModel().addListSelectionListener(new TableEditListener());
        tableRowHead.getSelectionModel().addListSelectionListener(new TableRowHeadSelectionListener());
        tableView.getSelectionModel().addListSelectionListener(new TableViewSelectionListener());

        tableView.addMouseListener(new MouseAdapter() {
                public void mousePressed(MouseEvent evt) {
                        int clickCount = evt.getClickCount();
                        int mask = evt.getModifiers();
//                        Debug.println("TV ClickCount:"+clickCount+" TV Editing? "+tableView.isEditing()+" Button: "+mask);
                        if ( mask == MouseEvent.BUTTON1_MASK && clickCount >= 4) {
                            System.out.println("Canceling edit");
                            tableView.editingCanceled(new ChangeEvent(tableView));
                            tableView.repaint();
                        }
                }
         });
 // aww test of mouse clicks
        tableRowHead.addMouseListener(new MouseAdapter() {
                public void mousePressed(MouseEvent evt) {
//                        Debug.println("TRH ClickCount:" + evt.getClickCount() + " TRH Editing? " + tableRowHead.isEditing());
                        if ( (evt.getModifiers() == (MouseEvent.BUTTON1_MASK | InputEvent.SHIFT_MASK)) 
                                && evt.getClickCount() >= 1) {
                                resetRowColumnSizes(tableRowHead, tableRowHead.getSelectedRow());
                                resetRowHeader(tableRowHead, tableDB);
                            tableDB.revalidate();
                        }
//                        else System.out.println("Shift failed");
                }
         });

        tableView.addMouseListener(new MouseAdapter() {
                public void mousePressed(MouseEvent evt) {
//                        Debug.println("TV ClickCount:" + evt.getClickCount() + " TV Editing? " + tableView.isEditing());
                        if ( (evt.getModifiers() == (MouseEvent.BUTTON3_MASK | InputEvent.SHIFT_MASK)) 
                                && evt.getClickCount() >= 1) {
                                resetRowColumnSizes(tableView, tableView.getSelectedRow());
//                                resetRowHeader(tableRowHead, tableDB);
                              tableView.revalidate();
                              tableDB.revalidate();
                        }
//                        else System.out.println("Shift failed");
                }
         });
 // end of mouse click test aww

// add rowheader models event listeners
        tcm.addColumnModelListener(tableRowHead);
        sorter.addTableModelListener(tableRowHead);
        sorter.addMouseListenerToHeaderInTable(tableRowHead);

// size the table viewport
        tableView.setPreferredScrollableViewportSize(tableView.getPreferredSize());

        tableDB = scrollpane;
        return scrollpane;
    } // end of createTable() method

    public JScrollPane createTable(int fontSize) {
        if (fontSize > 0) this.fontSize = fontSize;
        return createTable();
    }

    public JScrollPane createTable(Font font) {
        if (font != null) this.font = font;
        return createTable();
    }

    public static String getNumberFormatPattern(int scale) {
      StringBuffer pattern = new StringBuffer("#0");
      if (scale > 0) {
        char [] frac = new char[scale];
        Arrays.fill(frac, '0');
        pattern.append('.');
        pattern.append(frac);
      }
      return pattern.toString();
    }

    protected void initColumnSizes(JTable table) {
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;

        int colCount = table.getColumnCount();
        int rowCount = table.getRowCount();
// perhaps would be better to used subset for speed?
        int checkRows;
        if (rowCount > 200) checkRows = 200;  
        else checkRows = rowCount;
//        int padding = 0;
        for (int i = 0; i < colCount; i++) {
          column = table.getColumnModel().getColumn(i);
          comp = column.getHeaderRenderer().
                             getTableCellRendererComponent(
                                 table, column.getHeaderValue(), 
                                 false, false, 0, 0);
          headerWidth = comp.getPreferredSize().width;
          int maxCellWidth = 0;
          for (int j = rowCount-checkRows; j < rowCount; j++) {
            comp = table.getCellRenderer(j,i).
                             getTableCellRendererComponent(
                                 table, table.getValueAt(j,i),
                                 false, false, j, i);
            cellWidth = comp.getPreferredSize().width;
/*
            Insets insets =  ((Container) comp).getInsets();
            padding = insets.left + insets.right;
*/
            if (cellWidth > maxCellWidth) maxCellWidth = cellWidth;

          }
         
          column.setPreferredWidth(Math.max(headerWidth, maxCellWidth) + COLUMN_WIDTH_PADDING);
        }
    } 

    public boolean resetRowHeader(JTable table, JScrollPane scrollpane) {
        if (table == null || scrollpane == null) return false;
        table.setPreferredScrollableViewportSize(table.getPreferredSize());
        scrollpane.setRowHeaderView(table);
        scrollpane.setCorner(JScrollPane.UPPER_LEFT_CORNER, table.getTableHeader());
        return true;
    }

    public boolean resetRowColumnSizes(JTable table, int irow) {
        if (table == null) return false;
        int rowCount = table.getRowCount();
        if (irow < 0 || irow > rowCount) return false;
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        int colCount = table.getColumnCount();
        for (int i = 0; i < colCount; i++) {
          column = table.getColumnModel().getColumn(i);
          comp = column.getHeaderRenderer().
                             getTableCellRendererComponent(
                                 table, column.getHeaderValue(), 
                                 false, false, 0, 0);
          headerWidth = comp.getPreferredSize().width;
          int maxCellWidth = 0;
          comp = table.getCellRenderer(irow,i).
                       getTableCellRendererComponent(
                       table, table.getValueAt(irow,i),
                       false, false, irow, i);
          cellWidth = comp.getPreferredSize().width;
          if (cellWidth > maxCellWidth) maxCellWidth = cellWidth;
          column.setPreferredWidth(Math.max(headerWidth, maxCellWidth) + COLUMN_WIDTH_PADDING);
        }
        return true;
    } 

    public int getRenderedCellWidth(JTable table, int irow, int icol) {
        if (table == null) return -1;
        int rowCount = table.getRowCount();
        if (irow < 0 || irow > rowCount) return -1;
        int colCount = table.getColumnCount();
        if (icol < 0 || icol > colCount) return -1;
        TableColumn column = table.getColumnModel().getColumn(icol);
        if (column == null ) return -1;
        Component comp = table.getCellRenderer(irow,icol).
                getTableCellRendererComponent(
                table, table.getValueAt(irow,icol),
                false, false, irow, icol);
        return comp.getPreferredSize().width + COLUMN_WIDTH_PADDING;
    } 

    public int getPreferredRowWidth(JTable table, int irow) {
        if (table == null) return -1;
        int rowCount = table.getRowCount();
        if (irow < 0 || irow > rowCount) return -1;
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        int maxWidth = 0;
        int colCount = table.getColumnCount();
        for (int i = 0; i < colCount; i++) {
          column = table.getColumnModel().getColumn(i);
          comp = column.getHeaderRenderer().
                             getTableCellRendererComponent(
                                 table, column.getHeaderValue(), 
                                 false, false, 0, 0);
          headerWidth = comp.getPreferredSize().width;
          int maxCellWidth = 0;
          comp = table.getCellRenderer(irow,i).
                             getTableCellRendererComponent(
                                 table, table.getValueAt(irow,i),
                                 false, false, irow, i);
          cellWidth = comp.getPreferredSize().width;
          if (cellWidth > maxCellWidth) maxCellWidth = cellWidth;
          maxWidth += Math.max(headerWidth, maxCellWidth) + COLUMN_WIDTH_PADDING;
        }
        return maxWidth;
    }

    public int updateDB() {
        return tableModel.updateDB();
    }

 }
