package org.trinet.util.graphics;


//Title:        Your Product Name
//Version:      
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

//import org.trinet.jiggle;

import java.awt.*;
import javax.swing.*;

/** A centered informational box with no buttons. */
public class StatusFrame extends JFrame {

       boolean showProgress = true;

     BorderLayout borderLayout1 = new BorderLayout();
     JLabel textLabel = new JLabel();

     // make 0-100%
     JProgressBar progressBar = new JProgressBar(0, 100);
     JLabel graphicLabel = new JLabel();
     JPanel mainPanel = new JPanel();
     BorderLayout borderLayout2 = new BorderLayout();

     public StatusFrame() {
       this ("", "", null);
     }

     public StatusFrame(String title, String text, Icon icon) {
          try  {
               jbInit();
          }
          catch(Exception e) {
               e.printStackTrace();
          }

          set (title, text, icon);
     }
 
     public StatusFrame(String title, String text, Icon icon, boolean showProgress) {

          this.showProgress = showProgress;
          try  {
               jbInit();
          }
          catch(Exception e) {
               e.printStackTrace();
          }

          set (title, text, icon);
     }

     public void set(String title, String text,  Icon icon) {
        setTitle(title);
        setText(text);
        setIcon(icon);
        if (showProgress) setProgress(0);

        pack();
     }
/** Set the text in the text panel. */
     public void setText(String text) {
       textLabel.setText(text);
       pack();
     }

     public void setIcon (Icon icon) {
        graphicLabel = new JLabel(icon);
        pack();
     }

     public void setProgress (int percent) {
      if (showProgress) {
        progressBar.setValue(percent);
        progressBar.setString(percent+"%");
      }
     }

     public void setProgress (double percent) {
        setProgress( (int) percent);
     }

// Create the object (built using JBuilder)
     private void jbInit() throws Exception {
          this.getContentPane().setLayout(borderLayout1);
          textLabel.setText("status text here");
          mainPanel.setLayout(borderLayout2);
          mainPanel.setMinimumSize(new Dimension(200, 150));
          mainPanel.setPreferredSize(new Dimension(200, 150));
          this.getContentPane().add(mainPanel, BorderLayout.CENTER);
          mainPanel.add(graphicLabel, BorderLayout.WEST);
          mainPanel.add(textLabel, BorderLayout.CENTER);
          if (showProgress) {
            mainPanel.add(progressBar, BorderLayout.SOUTH);
            progressBar.setStringPainted(true);
          }
          
          centerDialog();
     }

/**
 * Center the dialog on the screen
 */
    protected void centerDialog() {
     Dimension screenSize = this.getToolkit().getScreenSize();
	Dimension size = this.getSize();
	screenSize.height = screenSize.height/2;
	screenSize.width = screenSize.width/2;
	size.height = size.height/2;
	size.width = size.width/2;
	int y = screenSize.height - size.height;
	int x = screenSize.width - size.width;
	this.setLocation(x,y);
    }

///////////////////////////////////////////////////////////
     public static void main(String[] args) {
          ImageIcon defIcon = new ImageIcon ("images/swing-64.gif");

          StatusFrame statusFrame =
          new StatusFrame("Test frame", "Something's happening", defIcon);

  //        statusFrame.pack();
          statusFrame.setVisible(true);

          statusFrame.setProgress(43);

     }
}
