package org.trinet.util.gazetteer.TN;
import org.trinet.util.gazetteer.*;
import java.sql.*;
import java.util.*;

public class WhereStation extends WhereAmI {
/** Default constructor does not set a reference point or a database connection */
    public WhereStation() {
	super();
    }
/** Constructor sets the database connection, does not set a reference point. */
    public WhereStation(Connection conn) {
	super(conn);
    }
/** Constructor sets the database connection and reference point. */
    public WhereStation(Connection conn, Geoidal reference) {
	super(conn, reference);
    }
/** Constructor sets the reference point, does not set a database connection. */
    public WhereStation(Geoidal reference) {
	super(reference);
    }
/** Constructor sets the reference point, does not set a database connection. 
* Elevation/depth input parameter is assumed to be in km units.
*/
    public WhereStation(double lat, double lon, double z) {
	super(lat, lon, z);
    }

/** Returns Vector of WhereItems constructed using station database data. */
    protected Vector getDatabaseData() {
	String sql = "SELECT STA, STANAME, LAT, LON, ELEV FROM STATION_DATA WHERE ONDATE <= SYSDATE AND (OFFDATE > SYSDATE OR OFFDATE = NULL)";
	Vector items = new Vector(2048);
	try {
	    Statement sm = conn.createStatement();
	    ResultSet rs = sm.executeQuery(sql); 
	    while (rs.next()) {
		BasicGazetteerPt bgp = new BasicGazetteerPt();
		bgp.name = rs.getString("STA");
		bgp.lat = rs.getDouble("LAT");	
		bgp.lon = rs.getDouble("LON");	
		bgp.z = rs.getDouble("ELEV") / 1000.;	
		bgp.state = "";
		bgp.remark = " station (" + rs.getString("STANAME") + ")";
		WhereItem whereItem = new WhereItemBasicPt(bgp);
		whereItem.setDistanceAzimuthElevation(reference);
		items.addElement(whereItem);
	    }
	    rs.close();
	    sm.close();
	}
	catch (SQLException ex) {
	    ex.printStackTrace();
	    return null;
	}
	return items;
    }
}
