
//Title:        Your Product Name
//Version:
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

package org.trinet.jiggle;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;

import java.util.Collection;
import org.trinet.jasi.ActiveList;

/**
* This is a dialog that allows adding, deleting and editing WaveServerGroups.
*/

public class WaveServerGroupEditDialog extends JDialog implements Observer {

     JPanel mainPanel = new JPanel();
     BorderLayout borderLayout1 = new BorderLayout();
     Box horizBox;
     JPanel leftPanel  = new JPanel();
     JPanel rightPanel = new JPanel();

     String title = "WaveServer Edit Dialog";
     TitledBorder leftBorderTitle  = new TitledBorder("WaveServer Group Profiles");
     TitledBorder rightBorderTitle = new TitledBorder("Edit WaveServer Group");

     JList jlist = new JList();
     JButton doneButton = new JButton();
     JPanel buttonPanel = new JPanel();

     WaveServerGroupDialogPanel  wsgDialog = new WaveServerGroupDialogPanel();

     JiggleProperties props;

     /** List of WaveServerGroups */
     ActiveList wsgList = new ActiveList();

     JButton newButton = new JButton();
     JButton deleteButton = new JButton();
     BorderLayout borderLayout2 = new BorderLayout();
     JLabel infoLabel = new JLabel();

     //

     public WaveServerGroupEditDialog(JiggleProperties props) {

          setModal(true);
          setTitle(title);

          this.props = props;

            // copy of the list in case we cancel
          setList(new ActiveList(props.getWaveServerGroupList()));
          try  {
               jbInit();
               pack();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }

          centerDialog();
          show();
     }

/** Set the WaveServerGroup that is shown in the right (edit) panel. */
     public void setGroup (WaveServerGroup grp) {

            rightPanel.removeAll();

            if (grp != null) {
              wsgDialog = new WaveServerGroupDialogPanel(grp);

              // set the list so dialog can add things to it
              wsgDialog.set(wsgList);

              rightPanel.add(wsgDialog, null);
            }
            rightPanel.revalidate();
     }

/** Set the list that shows in the left panel. */
     public void setList (ActiveList list) {

        if (list.isEmpty()) return;

        // stop listening to old list
        if (wsgList != null) wsgList.deleteObserver(this);

        this.wsgList = list;
        wsgList.addObserver(this);
        wsgDialog.set(wsgList);

        DefaultListModel model = new DefaultListModel();

        // put names in list
        for (int i = 0; i<wsgList.size(); i++) {
           String name = ((WaveServerGroup)wsgList.get(i)).getName();
           model.addElement(name);
        }
        jlist.setModel(model);

        jlist.addListSelectionListener(new ListListener());

        WaveServerGroup sel = WaveServerGroup.getSelected(wsgList);
        if (sel == null) {
          jlist.setSelectedIndex(0);
        } else {
          jlist.setSelectedValue(sel.getName(), true);
        }

        jlist.revalidate();
     }

     public void resetList() {
       setList(wsgList);
     }

     /** Handle selections from the list of WaveServer groups. */
     class ListListener implements ListSelectionListener {
        public void valueChanged (ListSelectionEvent evt) {

        JList src = (JList) evt.getSource();

//        System.out.println ("ListListener...");
            int index = src.getSelectedIndex();
// debug            System.out.println( "Selected index = " +index);

            // if there's no selection or the list is empty
            // getSelectedIndex returns -1
            if (index > -1) {
            // get the wsg thats selected in the JList
               WaveServerGroup wsg = (WaveServerGroup) wsgList.get(index);
               // make it selected in the wsgList
               WaveServerGroup.setSelected(wsg, wsgList);
               // show it in the right panel
               setGroup(wsg);
            } else {
               setGroup(null);
            }

        }
     }

     //
     void jbInit() throws Exception {
          horizBox = Box.createHorizontalBox();
          mainPanel.setLayout(borderLayout1);

          leftPanel.setBorder(leftBorderTitle);
          leftPanel.setLayout(borderLayout2);
          rightPanel.setBorder(rightBorderTitle);

          doneButton.setActionCommand("DONE");
          doneButton.setText("DONE");
          doneButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    doneButton_actionPerformed(e);
               }
          });

          this.setTitle("WaveServer Group Editing");
          mainPanel.setMinimumSize(new Dimension(400, 274));
          mainPanel.setPreferredSize(new Dimension(400, 271));
          jlist.setBorder(BorderFactory.createLineBorder(Color.black));
          jlist.setPreferredSize(new Dimension(100, 200));
          newButton.setToolTipText("Create a new WaveServer Group");
          newButton.setText("NEW");
          newButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    newButton_actionPerformed(e);
               }
          });

          deleteButton.setToolTipText("Delete the selected WaveServer Group");
          deleteButton.setText("DELETE");
          deleteButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    deleteButton_actionPerformed(e);
               }
          });
          infoLabel.setText("Select profile to edit");
          getContentPane().add(mainPanel);
          mainPanel.add(horizBox, BorderLayout.CENTER);
          horizBox.add(leftPanel, null);

          leftPanel.add(jlist, BorderLayout.CENTER);
          leftPanel.add(infoLabel, BorderLayout.SOUTH);
          rightPanel.add(wsgDialog, null);
          mainPanel.add(buttonPanel, BorderLayout.SOUTH);
          buttonPanel.add(doneButton, null);
          buttonPanel.add(newButton, null);
          buttonPanel.add(deleteButton, null);

          horizBox.add(rightPanel, null);
     }
/**
 * Center the dialog on the screen
 */
    protected void centerDialog() {
     Dimension screenSize = this.getToolkit().getScreenSize();
	Dimension size = this.getSize();
	screenSize.height = screenSize.height/2;
	screenSize.width = screenSize.width/2;
	size.height = size.height/2;
	size.width = size.width/2;
	int y = screenSize.height - size.height;
	int x = screenSize.width - size.width;
	this.setLocation(x,y);
    }

    /** obs is and instance of ActiveList.MyModel and arg is and instance of
    * WaveServerGroup */
    public void update (Observable obs, Object arg)
    {

	// WaveServerGroup list changed
	if (arg instanceof WaveServerGroup)
	{
        resetList();
	}

    }

    /** Returns the currently selected WaveServerGroup. */
    public WaveServerGroup getSelected() {
           return WaveServerGroup.getSelected(props.getWaveServerGroupList());
    }
     /** Returns the list of WaveServerGroups. */
    public Collection getList() {
           return wsgList;
    }
/**
 * Main for testing class
 * Note, needs:  import java.awt.event.*;
 */
    public static void main(String s[])
    {

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	   {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

  /*
          ActiveList wsgList = new ActiveList();

          WaveServerGroup wsg = new WaveServerGroup("test1");

          wsg.addServer ("spring.gps.caltech.edu", 6500);
          wsg.addServer ("spring.gps.caltech.edu", 6501);
          wsg.addServer ("jet.gps.caltech.edu", 6500);
          wsg.addServer ("jet.gps.caltech.edu", 6501);

          wsgList.add(wsg);

          wsg = new WaveServerGroup("test2 with space");

          wsg.addServer ("hotspot.gps.caltech.edu", 6500);
          wsg.addServer ("hotspot.gps.caltech.edu", 6501);
          wsg.addServer ("jet.gps.caltech.edu", 6500);
          wsg.addServer ("jet.gps.caltech.edu", 6501);

          wsgList.add(wsg);

          wsg.setSelected(true);
  */
        JiggleProperties props = new JiggleProperties("properties");

        WaveServerGroupEditDialog wed = new WaveServerGroupEditDialog(props);

        frame.pack();
        frame.setVisible(true);

    }
     /** Delete a WaveServerGroup */
     void deleteButton_actionPerformed(ActionEvent e) {
        wsgList.delete( getSelected() );
     }

     /** Make a new WaveServerGroup */
     void newButton_actionPerformed(ActionEvent e) {

       WaveServerGroup newWsg = new WaveServerGroup("<new>");
       setGroup(newWsg);
     }

     /** All done, commit to changes */
     void doneButton_actionPerformed(ActionEvent e) {

          // replace the "original list with the modified one
         props.wsgList = (ActiveList) wsgList;

         // debug
//         props.dumpProperties();
//         System.out.println ("*** selected group = "+
//                           WaveServerGroup.getSelected(props.wsgList).getName());
         this.setVisible(false);	    // dismiss dialog
     }

}

