package org.trinet.jiggle;

import org.trinet.util.*;
import org.trinet.jasi.*;

/**
 * WFDataBox.java extends WFSelectionBox. Box adapts to changes of the
 * Waveform object.  The timespan and amp max/min values are not independently
 * settable. The getXXX() methods will always return the values determined from
 * the current Waveform data. This is necessary to insure that the correct value is
 * given even when the waveform is changed (or loaded for the first time).
 *
 *
 * Created: Mon Mar 20 16:44:11 2000
 *
 * @author Doug Given
 * @version */

public class WFDataBox extends WFSelectionBox {
    
    Waveform wf = null;

    public WFDataBox() {
	
    }
    
    public WFDataBox(Waveform wf) {

	set(wf);
    }

    public WFDataBox(TimeSpan ts, int ampMax, int ampMin )
    {
	super(ts, ampMax, ampMin);
    }

    public WFDataBox( WFSelectionBox sb )
    {
	super(sb);
    }

    public void set(Waveform wf) {

	this.wf = wf;

    }
    
/**
 * Return the associated waveform's time span (start/end).
 * Returns an empty TimeSpan instance if there is no waveform.
 */
public TimeSpan getTimeSpan()
{
    if (wf == null) return new TimeSpan();
    return (wf.getTimeSpan());
}

/**
 * Return the associated waveform's maximum amplitude in sample counts.
 * Returns 0 if there is no waveform.
 */
public double getMaxAmp()
{
    if (wf == null) return 0.0;
    return (wf.getMaxAmp());
}

/**
 * Return the associated waveform's minimum amplitude in sample counts. 
 * Returns 0 if there is no waveform.
 */
public double getMinAmp()
{
    if (wf == null) return 0.0;
    return (wf.getMinAmp());
}

} // WFDataBox
