package org.trinet.jiggle;

/**
 * This is the Main tool bar that will be visible in the frame at all times.<p>
 *
 * Images for button icons are loaded using the IconImage class to insure
 * transportablility. They must reside in the "/images" directory of the
 * CLASSPATH or the .jar file. (Ex: <classpath>/images/zagscroll.gif)

 *@see: IconImage */
// see:  http://java.sun.com/docs/books/tutorial/ui/swing/toolbar.html

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.TitledBorder;

import org.trinet.jasi.*;
import org.trinet.util.gazetteer.*;

public class MainToolBar extends JToolBar {

// panel components

    /** Panel containing event specific components; eventTypeChooser and
        solutionListComboBox*/
     SolutionPanel solPanel;

//    Box solPanelBox = Box.createHorizontalBox();

    // buttons that can be disabled
    JButton deleteButton;
    JButton finalButton;
    JButton saveButton;
    JButton saveAllButton;
    JButton nextButton;
    JButton locateButton;
    JButton mlButton;
    JButton mcButton;
    JButton newSolButton;
//    FixDepthButton fixDepthButton = new FixDepthButton();

    JToggleButton unpickButton;

    // must keep references to these so we can remove them as observers
//    SolutionListComboBox solCombo = new SolutionListComboBox();
//    EventTypeChooser typeChooser  = new EventTypeChooser();

    // one handler for all buttons
    ButtonHandler buttonHandler = new ButtonHandler();
//    FixButtonHandler fixButtonHandler = new FixButtonHandler();

// event handling stuff
    private Object objSelected;     // the menu, list or button item selected
    private String EventName;	    // String label of the event (e.g. "Exit")
    private String ItemName;

    MasterView mv;
    Jiggle mainFrame;		// the main frame buttons act on

/**
 * Event Handling: Local events come from the Buttons and the ID list. Button
 * events are are handled by HandleEvent and the list is handled HandleList. If
 * a menu is ever added to this panel we would handle it in HandleEvent
 * also. <p> The Menu is a component of MainFrame and not this panel. However,
 * we want to change a label on the panel in response to a menu selection in
 * MainFrame. Therefore, the lable object is public static allowing MinFrame to
 * change it.  */
public MainToolBar (Jiggle frm)
    {
      setMainFrame(frm);
      makeToolBar();
    }

public MainToolBar ()		    // constructor
    {
      makeToolBar();
    }

/**
 * Create the button panel
 */
 public void makeToolBar ()
    {

      setFloatable(true);	// allow user to move toolbar

      // Removed 4/19/00 does not work
      //      add(makeButton("File","dirtree.gif",
      //		     "Open file chooser", 'f'));

      addSeparator();

      add(makeButton("Catalog", "zagscroll.gif",
		     "Return to catalog listing", 'c'));

      addSeparator();

      deleteButton = makeButton("Delete", "dynamite.gif",
	        "Delete current solution", 'd');
      add(deleteButton);

      addSeparator();
      /*
      add(makeButton("Sort","assemble.gif",
	"Sort waveforms by distance from current origin", 's'));
      */
      addSeparator();


      locateButton = makeButton("Locate", "bullseye.gif",
		     "Calculate location & magnitude", 'l');
      add(locateButton);

      addSeparator();

      mlButton = makeButton("ML", "ML_32.gif",
		     "Calculate magnitude", 'm');
      add(mlButton);


      mcButton = makeButton("MC", "MC_32.gif",
		     "Calculate magnitude", 'c');
      add(mcButton);


      addSeparator();

      saveButton = makeButton("Save",  "save.gif",
		     "Save the current event", 's');
      add(saveButton);

      addSeparator();

      saveAllButton = makeButton("Save All", "saveall.gif",
		     "Save the all events", 'a');
      add(saveAllButton);

      addSeparator();

      finalButton = makeButton("Final",  "gavel.gif",
		     "Save the current event", 'f');
      add(finalButton);

      addSeparator();

      nextButton = makeButton("Next", "forward.gif",
		     "Get the next event", 'n');
      add(nextButton);

      addSeparator();

      // Unpicking mode toggle button
      /*
      JToggleButton unpickButton =
	  new JToggleButton ("Unpick", new ImageIcon(IconImage.getImage("/images/mop.gif")));
      unpickButton.setAlignmentY(CENTER_ALIGNMENT);
      unpickButton.setHorizontalTextPosition(AbstractButton.CENTER);
      unpickButton.setVerticalTextPosition(AbstractButton.BOTTOM);
      unpickButton.setToolTipText("Delete picks");
      unpickButton.setMnemonic('u');
      */

      unpickButton = makeToggleButton("Unpick", "mop.gif",
			   "Delete picks",  'u');
  
      unpickButton.addItemListener (new ItemListener () {

	  public void itemStateChanged(ItemEvent e) {
	      int state = e.getStateChange();
	      if (state == ItemEvent.SELECTED) {
		  mainFrame.setUnpickMode(true);
	      } else {
		  mainFrame.setUnpickMode(false);
	      }
	  }
      });

      add(unpickButton);

      addSeparator();

      // add (empty) solPanel - can't create until there's a masterView
/*
      solPanel.setBorder( new TitledBorder("Selected Solution") );
      // event type chooser


      typeChooser = new EventTypeChooser();
      typeChooser.addActionListener(new EventTypeComboHandler());
      typeChooser.setEnabled(false);

      solCombo = new SolutionListComboBox ()
      solPanelBox.add(new SolutionListComboBox ());	// empty chooser
      solPanelBox.add(Box.createHorizontalStrut(10));
      solPanelBox.add(typeChooser);
      // need JPanel for TitledBorder and Box for better control
*/

      solPanel = new SolutionPanel(mainFrame);
//      solPanel.add(solPanel);
      add(solPanel);

      addSeparator();
      newSolButton = makeButton("New Sol", "new0b.gif",
		     "Create a new, blank solution", 'n');

      add(newSolButton);

      addSeparator();
  
      add(makeButton("Repaint", "glue.gif",

		     "Repaint the screen", 'r'));
      // at start up there's no selected solution so...
      setEventEnabled(false);

    } // end of makeToolBar

/**
 * Method to stream line adding of buttons. Makes sure all buttons have the same
 * action handler.
 */
    JButton makeButton (String label, String iconFile) {
    // this handles finding the icons in the path
      Image image = IconImage.getImage(iconFile);

      JButton btn;

      if (image == null) {
	  btn = new JButton(label);
      } else {
	  btn = new JButton(label, new ImageIcon(image));
      }

      btn.addActionListener (buttonHandler);
      btn.setAlignmentY(CENTER_ALIGNMENT);
      btn.setHorizontalTextPosition(AbstractButton.CENTER);
      btn.setVerticalTextPosition(AbstractButton.BOTTOM);

      return btn;
    }

    JButton makeButton (String label, String iconFile, String tip)
    {
      JButton btn = makeButton(label, iconFile);
      btn.setToolTipText(tip);
      return btn;
    }

    JButton makeButton (String label, String iconFile, String tip, char mnem)
    {
      JButton btn = makeButton(label, iconFile, tip);
      btn.setMnemonic(mnem);	 // doesn't work, needs more support for focus, actions?
      return btn;
    }

/**
 * Method to stream line adding of buttons. Makes sure all buttons have the same
 * action handler.
 */
    JToggleButton makeToggleButton (String label, String iconFile)
    {
      Image image = IconImage.getImage(iconFile);

      JToggleButton btn;

      if (image == null) {
	  btn = new JToggleButton(label);
      } else {
	  btn = new JToggleButton(label, new ImageIcon(image));
      }

      //      btn.addActionListener (new ButtonHandler());
      btn.setAlignmentY(CENTER_ALIGNMENT);
      btn.setHorizontalTextPosition(AbstractButton.CENTER);
      btn.setVerticalTextPosition(AbstractButton.BOTTOM);

      return btn;
    }

    JToggleButton makeToggleButton (String label, String iconFile, String tip)
    {
      JToggleButton btn = makeToggleButton(label, iconFile);
      btn.setToolTipText(tip);
      return btn;
    }

    JToggleButton makeToggleButton 
	(String label, String iconFile, String tip, char mnem) {
      JToggleButton btn = makeToggleButton(label, iconFile, tip);
      btn.setMnemonic(mnem);	 // doesn't work, needs more support for focus, actions?
      return btn;
    }

/**
 * Set a reference to the main frame so we can call its methods
 */
    public void setMainFrame (Jiggle frm)
    {
      mainFrame = frm;
    }


/**
 * Set anything on the main tool bar that is dependent on the MasterView. For example: <p>
 *  1) JOriginComboBox<p>
 */
    public void setMasterView(MasterView mv) {
	this.mv = mv;
//	makeSolPanelBox();
     solPanel.setMasterView(mv);

    }
    /**
    * Make/remake the guts of the Solution Panel box. It has already been added to
    * the tool bar.
    */
/*
    public void makeSolPanelBox() {

	if (mv == null || mv.solList.size() == 0) return;

     // remove any dangling references to old components in MVC model
     mv.solList.removeChangeListener(solCombo);
     mv.solList.removeChangeListener(typeChooser);
     mv.solList.removeChangeListener(fixDepthButton);

     // [EVENT]
	solCombo = new SolutionListComboBox (mv.solList);
	solCombo.addActionListener(new SolutionComboHandler() );
	// solCombo must update if selected event changes

	// [TYPE] set selected 'type' correctly
	typeChooser = new EventTypeChooser(mv.getSelectedSolution().getEventTypeString());
	typeChooser.addActionListener(new EventTypeComboHandler());;

     // [FIX]
     fixDepthButton = new FixDepthButton(mv);
     fixDepthButton.addActionListener(fixButtonHandler);

     mv.solList.addChangeListener(solCombo);
     mv.solList.addChangeListener(typeChooser);
     mv.solList.addChangeListener(fixDepthButton);

// NOTE: creating a new box distroys the reference to the solPanelBox in the solPanel
//     solPanelBox = Box.createHorizontalBox(); // new
     solPanelBox.removeAll();

     solPanelBox.add(solCombo);
     solPanelBox.add(Box.createHorizontalStrut(10));
     solPanelBox.add(typeChooser);
     solPanelBox.add(Box.createHorizontalStrut(10));
     solPanelBox.add(fixDepthButton);
     }
 */
/** Enable/disable components that only make sense when there's selected
event.  */
  public void setEventEnabled(boolean tf) {
    deleteButton.setEnabled(tf);
    finalButton.setEnabled(tf);
    saveButton.setEnabled(tf);
    saveAllButton.setEnabled(tf);
    locateButton.setEnabled(tf);
    mlButton.setEnabled(tf);
    mcButton.setEnabled(tf);
//    typeChooser.setEnabled(tf);        // may not exist yet
    newSolButton.setEnabled(tf);
    nextButton.setEnabled(tf);
    unpickButton.setEnabled(tf);
    solPanel.setEnabled(tf);

  }

/** Get the Solution ID from the box and select it */
/*
    class SolutionComboHandler implements ActionListener {

	// this is the action taken when the selectedOrigin is changed
	  public void actionPerformed(ActionEvent e) {

	        SolutionListComboBox jc = (SolutionListComboBox) e.getSource();
             Solution sol = jc.getSelectedSolution();

 	        mv.solList.setSelected( sol, true );
       }

    }
*/
/** Handle changes to eventType made by the EventTypeChooser
 */
/*
    class EventTypeComboHandler implements ActionListener {

	// this is the action taken when the event type is selected
      public void actionPerformed(ActionEvent e) {

        Solution sol = mv.solList.getSelected();

        if (sol == null) return; // no solution

	JComboBox jc = (JComboBox) e.getSource();

	if ( jc.getSelectedItem() == null ) return;  // internal setSelected event

	String type =  (String) jc.getSelectedItem();

	// no change = no action
	if (type.equalsIgnoreCase(sol.getEventTypeString())) return;

	//X// set the type of the selected event
     sol.setEventType(type);

	System.out.println ("Event type set to "+ type);
	//	System.out.println ("status = "+status+ "  type= "+type);

     // if its a QUARRY, ask for a comment but supply a default string of the form:
	// "BORON QUARRY, CA"
        if (type.equalsIgnoreCase("QUARRY")) {

          // fix depth at whatever, probably 0.0
          if (mainFrame.props.getBoolean("fixQuarryDepth")) {     // fix quarries?
             sol.depth.setValue(mainFrame.props.getDouble("quarryFixDepth"));
          }

	     WhereIsClosestFrom whereEngine =
		    new WhereIsClosestFrom(DataSource.getDefaultConnection());

          // construct default comment
          LatLonZ latlonz = sol.getLatLonZ();
	     whereEngine.setReference(latlonz.getLat(), latlonz.getLon(), latlonz.getZ());
	     WhereSummaryItem wsi = whereEngine.getClosestQuarry();
	     String placeString = wsi.fromPlaceString(false);
	     // must strip of " from " which the Where class always tacks on the place name
	     if (placeString.startsWith(" from")) placeString = placeString.substring(6);

	     System.out.println (placeString);

	     mainFrame.addComment(placeString);

     // if its not a LOCAL, ask for a comment but don't supply a default string
	   } else if (!type.equalsIgnoreCase("LOCAL")) {
	    mainFrame.addComment();
        }

       // do this to force a change event to notify listners
       mv.solList.setSelected(sol);

      // update title bar, etc.
//      mainFrame.updateTextViews();  // now done by listener

      }

    }  // end of EventTypeComboHandler

 class FixButtonHandler implements ActionListener {
	public void actionPerformed (ActionEvent evt) {

          fixDepthButton.toggle();

     }
 }
*/
// this is the contol panel's event handler class, does menus, buttons
    class ButtonHandler implements ActionListener
    {

    // actual event handling happens here (we're using the Java 1.1 model)
	public void actionPerformed (ActionEvent evt) {
        // save and make public the string of the menu item selected

          objSelected = evt;
	  EventName =  evt.getActionCommand();

 // Code responses to button, menu and list actions here...
 
 // *** a menu item
	if (EventName == "Exit")
	{
//	   appletParent.stop();    // calls Jiggle's stop() method
     mainFrame.stop();
	}

// *** if button push
	else if (EventName == "File")
	{
	    //	    mainFrame.fileChooser.show();
	}

	else if (EventName == "Locate")
	{
	    mainFrame.relocate();
	    //	    mv.locate (mainFrame.props);
	}

	else if (EventName == "ML")
	{
	    mainFrame.scanML();
	}

	else if (EventName == "MC")
	{
	    mainFrame.scanMC();
	}

	else if (EventName == "New Sol")	    // create an new blank origin
	{
	    mainFrame.createNewSolution();
	}

	else if (EventName == "Catalog") // Change focus to catalog tab
	{
	    mainFrame.tabPane.setSelectedIndex(mainFrame.TAB_CATALOG);	
	}
	/* Not needed anything that changes the loc will resort automatically
	if (EventName == "Sort")    // Sort/resort the WFViews 
	{ 
	    mainFrame.reSortWFViews();	
	} 
	*/
	else if (EventName == "Delete")	// load the currently selected ID
     {
		mainFrame.deleteCurrentSolution();
     }

	else if (EventName == "Repaint")
	{
	    mainFrame.repaint();
	}
	else if (EventName == "Save")
	{
	    mainFrame.saveToDb();
	}

	else if (EventName == "Final")
	{
	    mainFrame.finalToDb();
	}

	else if (EventName == "Next")
	{
	    mainFrame.loadNextSolution();
	}

	else if (EventName == "Save All")
	{
	    mainFrame.saveAllToDb();
	}

// repaint the panel to update labels, etc.
        repaint();

	}	    // end of actionPerformed
    }	// end of HandleEvent class

 } // end of class


