package org.trinet.jiggle;

import java.awt.*;
import javax.swing.*;
//import com.borland.jbcl.layout.*;
import org.trinet.util.graphics.ColumnLayout;
import org.trinet.util.graphics.IntegerChooser;
import javax.swing.border.TitledBorder;

import java.awt.event.*;

/** Allow user to specify look and feel of WFGroupPanel */
public class GroupPanelConfigPanel extends JPanel {
     JPanel jPanel1 = new JPanel();
     JPanel jPanel2 = new JPanel();
     JLabel jLabel1 = new JLabel();
     JComboBox traceCountComboBox = new JComboBox();

     JLabel jLabel2 = new JLabel();
     //JComboBox secComboBox = new JComboBox();
     ZoomScaleComboBox secComboBox ;
     org.trinet.util.graphics.ColumnLayout vertLayout =
              new org.trinet.util.graphics.ColumnLayout();

    // list of values in the combobox, reserve the 0th entry for non-list values
    String countList[] = {"5", "10", "15", "20"};
    String timeList[] = {
      "ALL",
      "30.00",
      "60.00",
      "90.00",
      "120.00",
      "300.00"};
     int wfCount = 10;
     double secInView = 90.0;


     public GroupPanelConfigPanel (int wfInView, double secs) {

        this();

        setChannelCount(wfInView);
        setTimeWindow(secs);

     }

     public GroupPanelConfigPanel () {

          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }
     }

     public void setChannelCount (int val) {
        wfCount = val;
        traceCountComboBox.setSelectedItem(""+wfCount);
     }
     
     public void setTimeWindow (double sec) {
        secInView = sec;
        if (secInView < 0) {
          secComboBox.setCurrentValue("ALL");
        } else {
          secComboBox.setCurrentValue(secInView);
        }
     }

     private void jbInit() throws Exception {
          this.setLayout(vertLayout);

          this.setBorder(new TitledBorder("Group Panel Setup"));

          jLabel1.setPreferredSize(new Dimension(100, 17));
          jLabel1.setText("Channels in view");
          jLabel2.setPreferredSize(new Dimension(100, 17));
          jLabel2.setText("Seconds in view");

          traceCountComboBox.setPreferredSize(new Dimension(80, 24));
          traceCountComboBox.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    traceCountComboBox_actionPerformed(e);
               }
          });

          for (int i = 0; i < countList.length; i++) {
            traceCountComboBox.addItem(countList[i]);
          }
          traceCountComboBox.setEditable(true);
          traceCountComboBox.setSelectedItem(""+wfCount);

          secComboBox = new ZoomScaleComboBox(timeList);
          secComboBox.setCurrentValue(secInView);

          secComboBox.setPreferredSize(new Dimension(80, 24));
          secComboBox.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    secComboBox_actionPerformed(e);
               }
          });

          this.add(jPanel1, null);
          jPanel1.add(jLabel1, null);
          jPanel1.add(traceCountComboBox, null);
          this.add(jPanel2, null);
          jPanel2.add(jLabel2, null);
          jPanel2.add(secComboBox, null);
     }

     void traceCountComboBox_actionPerformed(ActionEvent e) {
         //noop
     }

     void secComboBox_actionPerformed(ActionEvent e) {
         //noop
     }

     public int getChannelCount() {
        int selected;
        String str = (String) traceCountComboBox.getSelectedItem();
//        if (str == null) return selected;
        try {
          selected = Integer.parseInt(str);
        } catch (NumberFormatException e) {
	     System.out.println (" % Bad number format in IntegerChooser: " + "\""+  str + "\"" );
          // fall back to previously selected value
          traceCountComboBox.setSelectedItem( String.valueOf(wfCount) );
	     return wfCount;
        }

        return selected;
     }

     public double getTimeWindow() {
       return secComboBox.getValue();
     }
}

