package org.trinet.jdbc.table;
import org.trinet.jdbc.*;
import java.sql.Date;

public abstract class ResponseStnTableRow extends DataTableRow {

    public ResponseStnTableRow (String tableName, String sequenceName, int maxFields, int[] keyColumnIndex,
                String [] fieldNames, boolean [] fieldNulls, int [] fieldClassIds ) {
        super(tableName, sequenceName, maxFields, keyColumnIndex, fieldNames, fieldNulls, fieldClassIds);
    }

/** Overrides DataTableRow.clone()
*/
    public Object clone() {
        ResponseStnTableRow obj = null;
        obj = (ResponseStnTableRow) super.clone();
        return obj;
    }

/** Returns table row count.
*/
    public int getRowCount() {
	return ExecuteSQL.getRowCount(connDB, getTableName());
    }

/** Returns table row count of the active stations for the specified date.
* Input date string must be of the form 'YYYY-MM-DD'.
* If date == null the date SYSDATE function is used for the active date.
*/
    public int getRowCountByDate(String date) {
	return getRowCountByDate(Date.valueOf(date));
    }

/** Returns table row count of the active stations for the specified date.
* If date == null the date SYSDATE function is used for the active date.
*/
    public int getRowCountByDate(Date date) {
	String whereString;
	if (date != null)
	    whereString = " WHERE (OFFDATE > " + StringSQL.valueOf(date) +
			" OR OFFDATE = NULL) AND ONDATE <= " + StringSQL.valueOf(date);
	else
	    whereString = " WHERE (OFFDATE > SYSDATE OR OFFDATE = NULL) AND ONDATE <= SYSDATE";

	return ExecuteSQL.getRowCount(connDB, getTableName(), "*", whereString);
    }

/** Returns table row count corresponding to the specified date and net.
* Input date string must be of the form 'YYYY-MM-DD'.
* If the input date == null, the date returned by the SYSDATE function is used.
*/
    public int getRowCountByDate(String date, String net) {
	return getRowCountByDate(Date.valueOf(date), net);
    }

/** Returns table row count corresponding to the specified date and net.
* If the input date == null, the date returned by the SYSDATE function is used.
*/
    public int getRowCountByDate(Date date, String net) {
	String whereString = "WHERE NET = " + StringSQL.valueOf(net);
	if (date != null)
	    whereString = whereString +" AND (OFFDATE > " + StringSQL.valueOf(date) +
			" OR OFFDATE = NULL) AND ONDATE <= " + StringSQL.valueOf(date);
	else
	    whereString = whereString + " AND (OFFDATE > SYSDATE OR OFFDATE = NULL) AND ONDATE <= SYSDATE";

	return ExecuteSQL.getRowCount(connDB, getTableName(), "*", whereString);
    }

/** Returns table row count corresponding to the specified date, net, and station.
* Input date string must be of the form 'YYYY-MM-DD'.
* If the input date == null, the date returned by the SYSDATE function is used.
*/
    public int getRowCountByDate(String date, String net, String sta) {
	return getRowCountByDate(Date.valueOf(date), net, sta);
    }

/** Returns table row count corresponding to the specified date, net, and station.
* If the input date == null, the date returned by the SYSDATE function is used.
*/
    public int getRowCountByDate(Date date, String net, String sta) {
	String whereString = "WHERE NET = " + StringSQL.valueOf(net) +
				" AND STA = " + StringSQL.valueOf(sta);
	if (date != null)
	    whereString = whereString +" AND (OFFDATE > " + StringSQL.valueOf(date) +
			" OR OFFDATE = NULL) AND ONDATE <= " + StringSQL.valueOf(date);
	else
	    whereString = whereString + " AND (OFFDATE > SYSDATE OR OFFDATE = NULL) AND ONDATE <= SYSDATE";
	return ExecuteSQL.getRowCount(connDB, getTableName(), "*", whereString);
    }

/** Returns an array where each element contains the data from a single table row parsed from an SQL query
* WHERE the station was active on the specified input date, network, and station.
* Input date string must be of the form 'YYYY-MM-DD'.
* If the input date == null, the date returned by the SYSDATE function is used.
* A return value of null indicates no data or an error condition.
*/
    public Object getRowsByDate(String date, String net, String sta) {
	return getRowsByDate(Date.valueOf(date), net, sta);
    }

/** Returns an array where each element contains the data from a single table row parsed from an SQL query
* WHERE the station was active on the specified input date, network, and station.
* If the input date == null, the date returned by the SYSDATE function is used.
* A return value of null indicates no data or an error condition.
*/
    public Object getRowsByDate(Date date, String net, String sta) {
	String whereString = "WHERE NET = " + StringSQL.valueOf(net) +
				" AND STA = " + StringSQL.valueOf(sta) ;
	if (date != null)
	    whereString = whereString +" AND (OFFDATE > " + StringSQL.valueOf(date) +
			" OR OFFDATE = NULL) AND ONDATE <= " + StringSQL.valueOf(date);
	else
	    whereString = whereString + " AND (OFFDATE > SYSDATE OR OFFDATE = NULL) AND ONDATE <= SYSDATE";
	return getRowsEquals(whereString);
    }

/** Returns an array where each element contains the data from a single table row parsed from an SQL query
* WHERE the station was active on the specified input date and network.
* Input date string must be of the form 'YYYY-MM-DD'.
* If the input date == null, the date returned by the SYSDATE function is used.
* A return value of null indicates no data or an error condition.
*/
    public Object getRowsByDate(String date, String net) {
	return getRowsByDate(Date.valueOf(date), net);
    }

/** Returns an array where each element contains the data from a single table row parsed from an SQL query
* WHERE the station was active on the specified input date and network.
* If the input date == null, the date returned by the SYSDATE function is used.
* A return value of null indicates no data or an error condition.
*/
    public Object getRowsByDate(Date date, String net) {
	String whereString = "WHERE NET = " + StringSQL.valueOf(net) ;
	if (date != null)
	    whereString = whereString +" AND (OFFDATE > " + StringSQL.valueOf(date) +
			" OR OFFDATE = NULL) AND ONDATE <= " + StringSQL.valueOf(date);
	else
	    whereString = whereString + " AND (OFFDATE > SYSDATE OR OFFDATE = NULL) AND ONDATE <= SYSDATE";
	return getRowsEquals(whereString);
    }

/** Returns an array where each element contains the data from a single table row parsed from an SQL query
* WHERE the station was active on the specified input date.
* Input date string must be of the form 'YYYY-MM-DD'.
* If the input date == null, the date returned by the SYSDATE function is used.
* A return value of null indicates no data or an error condition.
*/
    public Object getRowsByDate(String date) {
	return getRowsByDate(Date.valueOf(date));
    }

/** Returns an array where each element contains the data from a single table row parsed from an SQL query
* WHERE the station was active on the specified input date.
* If the input date == null, the date returned by the SYSDATE function is used.
* A return value of null indicates no data or an error condition.
*/
    public Object getRowsByDate(Date date) {
	String whereString;
	if (date != null)
	    whereString = " WHERE (OFFDATE > " + StringSQL.valueOf(date) +
			" OR OFFDATE = NULL) AND ONDATE <= " + StringSQL.valueOf(date);
	else
	    whereString = " WHERE (OFFDATE > SYSDATE OR OFFDATE = NULL) AND ONDATE <= SYSDATE";
	return getRowsEquals(whereString);
    }

}

