package org.trinet.jasi;

import org.trinet.jasi.Solution;
import org.trinet.util.gazetteer.*;
import org.trinet.util.*;
import org.trinet.util.velocitymodel.*;
/**
 * Friendly interface to org.trinet.util.velocitymodel
 */
public class TravelTime
{
// temporary hardwired stuff should come from property file
//    static final double VELOCITY = 6.3;
//    static final double POISSON = 1.78;

    PrimarySecondaryWaveTravelTimeGeneratorIF ttGenerator;

    static TravelTime defaultTT = null;


public TravelTime(UniformFlatLayerVelocityModelIF model) {
       ttGenerator   = new TTLayer(model);
       setSourceZ(6.0);  // 6km depth
}

// UniformFlatLayerVelocityModel.SOCAL_DEFAULT
public TravelTime(UniformFlatLayerVelocityModelIF model, Geoidal source) {
       ttGenerator   = new TTLayer(model);
       setSource(source);
}

/** Returns default model. */
public TravelTime() {
      this(UniformFlatLayerVelocityModel.SOCAL_DEFAULT);
}
/** Singleton */
public static TravelTime getInstance(UniformFlatLayerVelocityModelIF model) {
   // create the single instance
   if (defaultTT == null) defaultTT = new TravelTime(model);
   return defaultTT;
}

public static TravelTime getInstance() {
   // create the single instance
   if (defaultTT == null) defaultTT = new TravelTime();
   return defaultTT;
}

public void setSource (Geoidal source) {
    if (ttGenerator != null) ttGenerator.setSource(source);
}

public void setSource (Solution sol) {
    if (ttGenerator != null) ttGenerator.setSource(sol);
}

public void setSourceZ (double depthKm) {
    setSource(new LatLonZ( 0.0, 0.0, depthKm));
}

/** Assumes both source and receiver at zero depth. */
public double getTTp (double dist) {
      return ttGenerator.pTravelTime(dist);
}
/** Assumes source at 'depth' and receiver at zero depth. */
public double getTTp (double dist, double depth) {
      setSourceZ(depth);
      return ttGenerator.pTravelTime(dist);
}
/** Assumes source at 'depth' and receiver at zero depth. */
public double getTTp (LatLonZ source, LatLonZ receiver) {
    double dist = source.horizontalDistanceFrom(receiver);
    setSource(source);
    return getTTp(dist);
}
//
public double getTTs (double dist) {
    return getTTp(dist) * getPSRatio();
}
public double getTTs (double dist, double depth) {
    return getTTp(dist, depth) * getPSRatio();
}

public double getTTs (LatLonZ source, LatLonZ receiver) {
    return getTTp(source, receiver) * getPSRatio();
}

/** More efficient to get them together. */
public DoubleRange getTTps (double dist) {
   double p = getTTp(dist);
   return new DoubleRange(p, p*getPSRatio());
}
public DoubleRange getTTps (double dist, double depth) {
   double p = getTTp(dist, depth);
   return new DoubleRange(p, p*getPSRatio());
}
public DoubleRange getTTps (LatLonZ source, LatLonZ receiver) {
   double p = getTTp(source, receiver);
   return new DoubleRange(p, p*getPSRatio());
}


public double getPSRatio() {

    return ((UniformFlatLayerVelocityModelIF) ttGenerator.getModel()).getPSRatio();

}


    public static void main (String args[]) {

      //TravelTime tt = new TravelTime();
      TravelTime tt = TravelTime.getInstance();

      for (int i =0; i<=100; i += 5) {
         System.out.println (i + "   "+  tt.getTTp(i) + "  "+tt.getTTs(i));
      
      }

    }
}
