package org.trinet.filters;

import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import org.trinet.jiggle.*;
import org.trinet.jasi.*;

public class AccelFilter extends GenericFilter {

/** resdat.TK parameters */
    int demeanPointCount = 80;  // nb

    double qHighPass = 0.998;   // qb, qp, qs

    double maxWindowSize = 5.0; // tint

    double taperStart = 0.02;  // begin
    double taperEnd   = 0.10;  // end

    /** The segment being filtered. */
    WFSegment seg;

     public AccelFilter() {
     }

/*
     public AccelFilter(Properties props) {
        super(props);
     }
*/
     public AccelFilter(double gainfactor) {
        super();

        this.gainFactor = gainfactor;

///        filter = new AccFilter();
     }

/** Returns this same segment with the time-series Filtered.*/
     public WFSegment filterSegment (WFSegment seg) {

       this.seg = seg;

     // note we DON'T call setSamples because we don't want to recalc bias, etc.
       seg.setTimeSeries( demean(seg.getTimeSeries()), false );

       // new filtered time series
       // setSamples forces recalc of bias, max, min. Don't make a copy of timeseries.
       seg.setTimeSeries(this.filterTimeSeries(seg.getTimeSeries()));

       return seg;
     }

     /** Set the units for the resulting waveform. */
     void setUnits(Waveform wf) {
       wf.setAmpUnits(Units.CMS2);         // accel = cm/sec^2
     }

/** Return recursively filtered timeseries given a timeseries. */
       private float[] filterTimeSeries (float[] ts) {

         if (ts.length < 3) return ts;

       // Hiroo's magic numbers
         final double c0 = -0.7721187782;
         final double c1 = -0.3788779578;
         final double c2 =  1.1509967359;

         final double dd0 =  0.102101057;
         final double dd1 = -0.8593897;

         float acc[] = new float[ts.length];

         float b0 = 2.0f / (1.0f + (float) qHighPass);

         float dt = (float) seg.getSampleInterval();
         int sps = (int) (1.0/dt);

         // set first sample value
         acc[0] = 0;
         acc[1] = 0;

         if (sps > 20) {         // 80 or 100 sps

           float coef = b0 * (float) gainFactor;

           for (int i = 2; i < ts.length -3; i++) {

             float delta    = ts[i] - ts[i-1];
             float tail  = (float) qHighPass * acc[i-1];
             float front = delta / coef;
             acc[i] = front + tail;
           }

         // *******************************
         // **NOTE** this is untested!!!!!  (couldn't find a 20 sps triggered wf)
         // *******************************
         } else {                 // 20 sps

           for (int i = 2; i < ts.length -3; i++) {

             acc[i] =(float) (
                      (c2*ts[i] + c1*ts[i-1] + c0*ts[i-2]) /
                      (dt*gainFactor) + (dd1*acc[i-1])+(dd0*acc[i-2])
                      );
           }
         }

         return acc;


       }
/*
public static void debugDump(Waveform wfx) {

             // after filtering
     System.out.println ( " ----------- Dump ");
		System.out.println ("Got waveform: nsegs =  "+ wfx.getSegmentList().size() );
		//	    System.out.println ("Expected samps = "+ wfx.sampleCount.toString() );
		System.out.println ("Actual samps   = "+ wfx.samplesInMemory() );
		System.out.println ("max = "+ wfx.getMaxAmp());
		System.out.println ("min = "+ wfx.getMinAmp());
		System.out.println ("bias= "+ wfx.getBias());

     float sample[] ;

     WFSegment segs[] = wfx.getArray();
     for (int i = 0; i < segs.length; i++) {
             System.out.println ( segs[i].toString() );
             sample = segs[i].getTimeSeries();
             for (int k = 0; k < 10; k++){
               System.out.print (" "+sample[k]);
             }
             System.out.println ();
     }
}
*/
// ////////////////
/**
 * Main for testing
 */
    public static void main (String args[])
    {

        System.out.println ("Making connection...");
	DataSource init = new TestDataSource();  // make connection

	int wfid = 10014410;        // 100 sps

	Waveform wfx = Waveform.create();

	    wfx = wfx.getByWaveformId(wfid);

	    System.err.println ("Fetching waveform: "+wfx.getChannelObj().toString());

	    if (!wfx.loadTimeSeries()) {
		System.out.println ("Waveform retreival failed.");
          System.exit (0);
	    }

         // must look up the gain
          wfx.setChannelObj(Channel.lookUp(wfx.getChannelObj()));

          System.out.println ("channel= "+wfx.getChannelObj()+
                              "  gain= "+wfx.getChannelObj().gain.toString());

          debugDump(wfx);    // debug

     AccelFilter accFilter = new AccelFilter();
 //    AccelFilter filter = new AccelFilter(wfx.chan.gain.doubleValue());

    Waveform filteredWf = accFilter.filter(wfx);
//    Waveform newWf = wfx;

      debugDump(wfx);    // debug
      debugDump(filteredWf);    // debug

     // make a main frame
        JFrame frame = new JFrame("Test");

        WFView wfview1 = new WFView(wfx);
        WFPanel panel1 = new WFPanel(wfview1);

        // filter
        WFView wfview2 = new WFView(filteredWf);
        WFPanel panel2 = new WFPanel(wfview2);

        panel1.setSize(200,200);
        panel2.setSize(200,200);
        panel1.setBackground(Color.yellow);
        panel2.setBackground(Color.white);

	// make a split pane
	JSplitPane split = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
			   false,       // don't repaint until resizing is done
			   panel1,      // top component
			   panel2);

       frame.setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

	   frame.getContentPane().add(split);

        frame.pack();
        frame.setVisible(true);
        panel1.setSize(200,500);
        panel2.setSize(200,500);
        }

}
