package org.trinet.util.graphics.table;
import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.util.*;
import java.text.*;
import org.trinet.util.*;
import org.trinet.jdbc.datatypes.*;

public class IntervalRenderer extends DefaultTableCellRenderer {
    public void setValue(Object value) {
	if (value == null) {
	    super.setValue("");
	}
	else if (value instanceof Number) {
	    super.setValue(EpochTime.elapsedTimeToText((Number) value));
	}
	else if (value instanceof DataObject) {
	    super.setValue(EpochTime.elapsedTimeToText( ((DataObject) value).intValue()) );
	}
	else {
	    super.setValue(value);
	}
    }
}
