import java.text.*;
import java.util.*;
import java.net.URL;
import java.sql.*;

import org.trinet.jdbc.*;
import org.trinet.util.*;
import org.trinet.jasi.*;
import org.trinet.eventmatch.*;
import org.trinet.jiggle.*;

/**
 * This is quicker then CatalogList because it doesn't count the Waveforms.
 */


public class Test 

{

/** Make an empty Test */
public Test () 
{

}

/** 
 * Main for testing: % Test [hours-back]  (default = 1)
 */
    public static void main (String args[]) {

	double hoursBack;
	final int secondsPerHour = 60*60;

	if (args.length > 0)	// translate epoch second on command-line value 
	{
	  Double val = Double.valueOf(args[0]);	    // convert arg String to 'double'
	  hoursBack = (double) val.doubleValue();
	} else {
	  System.out.println ("Usage: java Test [hours-back]  (default=24)");
	  hoursBack = 24;	// default
	}

	// make connection
	String driver = "oracle.jdbc.driver.OracleDriver";
	String url    = "jdbc:oracle:thin:@quake.gps.caltech.edu:1521:quakedb";
	String user   = "trinetdb";
	String passwd = "calgs";

        System.out.println ("Making connection... "+url);

	DataSource init = new DataSource (url, driver, user, passwd);    // make connection

        Calendar cal = Calendar.getInstance();

// must distinguish between 'java.util.Date'  and 'java.sql.Date'
	java.util.Date date = cal.getTime();	// current epoch millisec
	long now = date.getTime()/1000;	// current epoch sec (millisecs -> seconds)
	long then = now - (long) (secondsPerHour * hoursBack);	// convert to seconds
    // add 1000 to now just to be sure we get everything

	System.out.println ("Fetching last "+hoursBack+" hours...");

	//	Solution.setQuickDump(true);

	// Get ALL events
	//	Solution sol[] = Solution.create().getValidByTime(then, now);
	//      	Solution sol[] = Solution.create().getByTime(then, now);


	// selectflag 0 events	
	//	String sql = " Event.selectflag = 0 and datetime > "+then;

	//  437 ISAIAH events
	String sql = "Event.auth = 'RTP' and Event.evid > 10000000";

	System.out.println (sql);
	SolutionTN sol[] = SolutionTN.getWhere(sql);
	long evidm;

    	for (int i = 0; i < sol.length; i++)
	{
	    // Only operate on RT2 (backup) event
	    //	    if (sol[i].source.toString().equals("RT2")){
		System.out.println ("-------------");
		System.out.println (sol[i].toSummaryString() + " " +
				    sol[i].authority.toString() + " " +
				    sol[i].source.toString() + " " +
				    sol[i].processingState.toString());	

		
		evidm = EventMatch.getMatchEvid (sol[i].lat.doubleValue(),
				      sol[i].lon.doubleValue(),
				      sol[i].depth.doubleValue(),
				      sol[i].datetime.doubleValue());

		if (evidm > -1) System.out.println ("MATCH = "+evidm);
		//	    }

	}

    }

} // end of class


