package org.trinet.pcs;

  /**
   * Put an data object in the given state/rank.
   *  % SYNTAX: puttrans <group> <table> <oldState> <result> <newState> <rank>
   */
class PutTransition
{

  public static void main (String args[])
    {
      TransitionRow tr = new TransitionRow();

      if (args.length != 4 && args.length != 6 )
	{
	  System.out.println("SYNTAX: puttrans <group> <table> <oldState> <result> [<newState>] [<rank>]");
	  return ;
	}

      try {
      tr.controlGroup = args[0];
      tr.sourceTable  = args[1];
      tr.stateOld     = args[2];
      tr.result       = Integer.valueOf(args[3]).intValue(); 

      tr.subsource = System.getProperty("user.name", "unknown")+"               " ;
      tr.subsource = tr.subsource.substring(0,8).trim();

      if (args.length == 6)
	{	  
	  tr.stateNew     = args[4];
	  tr.rank         = Integer.valueOf(args[5]).intValue();
	  // get user's username 
	  tr.subsource = System.getProperty("user.name", "unknown")+"               " ;
	  tr.subsource = tr.subsource.substring(0,8).trim();
	};
      } catch (Exception e){
	 System.out.println(" Malformed command.");
	 System.out.println("SYNTAX: puttrans <group> <table> <oldState> <result> [<newState>] [<rank>]");
      }

	tr.insert();		// write it to the dbase

	// dump current transitions
	TransitionRow tra[] = 
	  TransitionRow.get (tr.controlGroup, tr.sourceTable); 

	TransitionRow.dump(tra);

    }

}
