  /**
   * Structure of the Process Table
   */

//package ProcessControlSystem;
package org.trinet.pcs;

import java.sql.*;
import java.util.*;
//import sqlj.runtime.ref.DefaultContext;
//import oracle.sqlj.runtime.Oracle;
import oracle.jdbc.driver.*;
import oracle.sql.*;

public class ProcessRow
{
  int    id;			// NOT NULL
  String controlGroup;		// NOT NULL
  String sourceTable;		// NOT NULL
  String state;			// NOT NULL
  int    rank;			// NOT NULL
  int	 result;
  int    secondaryId;
  String secondarySourceTable;
  String auth;			// NOT NULL
  String subsource;
  java.sql.Date lddate;

  public ProcessRow() {}	// null constructor

  /**
   * Copy a Process Row
   */
  public ProcessRow(ProcessRow pr) 
    {
      id =		pr.id;			// NOT NULL
      controlGroup =	pr.controlGroup;		// NOT NULL
      sourceTable =	pr.sourceTable;		// NOT NULL
      state =		pr.state;			// NOT NULL
      rank =		pr.rank;			// NOT NULL
      result =		pr.result;
      secondaryId =	pr.secondaryId;
      secondarySourceTable = pr.secondarySourceTable;
      auth =		pr.auth;			// NOT NULL
      subsource =	pr.subsource;
      lddate =		pr.lddate;

    }

  /**
   * Insert ONE process row into the dbase
   */
  public int insert ()
    {
      String sql = "INSERT into Process ("+
	fieldString() +
	" , lddate) values (" +
	toValueString() + 
	", SYSDATE)" ;
      
      return doUpdate (sql);

    }

  /**
   * Insert all these process rows into the dbase
   */
  public static int insertArray (ProcessRow pr[])
    {
      int nrows=0;
      for (int i = 0; i < pr.length; i++)
	{
	 nrows += pr[i].insert();
	}
      return nrows;
    }

  /**
   * Delete this process row
   */
  public int delete ()
    {
      String sql = "Delete from Process where "+
	" controlGroup = '"+controlGroup+"'"+
	" and sourceTable = '"+sourceTable+"'"+
	" and id = "+id+
	" and state = '"+state+"'"+
	" and rank = "+ rank;

      return doUpdate (sql);

    }

  /**
   * Delete this process row
   */
  public static int delete (String cGroup, String sTable, int id)
    {
      String sql = "Delete from Process where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+sTable+"'"+
	" and id = "+id;

      return doUpdate (sql);

    }

  /**
   * Delete this process row
   */
  public static int delete (String cGroup, String sTable)
    {
      String sql = "Delete from Process where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+sTable+"'";

      return doUpdate (sql);

    }

  /**
   * Delete this process row
   */
  public static int delete (String cGroup)
    {
      String sql = "Delete from Process where "+
	" controlGroup = '"+cGroup+"'";

      return doUpdate (sql);

    }

  public static int doUpdate(String sql)
    {
      ProcessControl.makeConnection();

      int nrows = 0;
      try {
	Statement stmt = ProcessControl.conn.createStatement();
	nrows = stmt.executeUpdate(sql);
	ProcessControl.conn.commit();
	stmt.close(); 
      }
      catch (SQLException ex) {
	ex.printStackTrace(System.out);
	System.err.println("SQL: " + sql);
      }

      return nrows;
    }

 /** ******************************************************************
   * Return all Process Table rows for this group/table/ID sorted by 
   * rank in descending order
   */
  public static 
    ProcessRow[] get(String cGroup, String cTable, int id)

    { 
      String sql = 
	"SELECT * from Process where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+cTable+"'"+
	" and id = "+id +" order by rank DESC";

      return doQuery(sql);
    }

  /** 
   * Return all Process table rows for this group/table/state.
   */
  public static ProcessRow[] get(String cGroup, String cTable, String state)

    { 
//    String sql = "SELECT * from Process where id = "+id +" order by rank";
      String sql = 
	"SELECT * from Process where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+cTable+"'"+
	" and state = '"+state+"'"+
	" order by result DESC";

      return doQuery(sql);
    }

  /** 
   * Return all Process table rows for this group/table
   */
  public static ProcessRow[] get(String cGroup, String cTable)

    { 
//    String sql = "SELECT * from Process where id = "+id +" order by rank";
      String sql = 
	"SELECT * from Process where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+cTable+"'"+
	" order by result DESC";

      return doQuery(sql);
    }
  /** 
   * Return all Process table rows for this group
   */
  public static ProcessRow[] get(String cGroup)

    { 
      String sql = 
	"SELECT * from Process where "+
	" controlGroup = '"+cGroup+"'"+
	" order by result DESC";

      return doQuery(sql);
    }
  /** 
   * Return all Process table rows
   */
  public static ProcessRow[] get()

    { 
      String sql = 
	"SELECT * from Process order by id, state, rank, result DESC";

      return doQuery(sql);
    }

  /** 
   * Return all Process table rows with non-zero result codes. These are
   * likely to require transitions
   */
  public static ProcessRow[] getNonNullResults()

    { 
      String sql = 
	"SELECT * from Process where "+
	"(result <> 0 or result is not null) order by result DESC";

      return doQuery(sql);
    }

  /** 
   * Return all Process table rows with non-zero result codes. These are
   * likely to require transitions
   */
  public static ProcessRow[] getNonNullResults(String cGroup, String cTable)

    { 
      String sql = 
	"SELECT * from Process where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+cTable+"'"+
	" and (result <> 0 or result is not null) order by result DESC";

      return doQuery(sql);
    }

  /**
   * Return all Process Table rows that satisfy this 'sql' query
   */
  public static ProcessRow[] doQuery (String sql)
    { 
      ResultSet rs;
      int nrows = 0;
      ProcessRow prRow;
      Vector v = new Vector() ;

      ProcessControl.makeConnection(); // use existing or make new connection

      try {

	Statement stmt = ProcessControl.conn.createStatement();

	rs = stmt.executeQuery(sql);

	while ( rs.next() ) {
	  prRow = ProcessRow.parse(rs);
	  if (prRow == null) break;
	  v.addElement((Object) prRow);
	  nrows++;
	}

	stmt.close();		//closes statement & resultset

      } catch (SQLException ex) {
	ex.printStackTrace(System.out);
	return null;
      }
      
      if ( v.size() > 0) {
	ProcessRow pr[] = new ProcessRow [nrows];
	v.copyInto(pr);
	return pr;
      }
      else {
	return null;
      }
      
    }

/** 
 * Convert data members to a comma delimited list for use with INSERT and UPDATE.
 * Note that 'lddate' is not included 
 */
  public String toValueString()
    {
	return 
	  znull(id) + ", " +
	  "'"+ controlGroup + "', " +
	  "'"+ sourceTable + "', " +
	  "'"+ state + "', " +
	  znull(rank) + ", " +
	  znull(result) + ", " +
	  znull(secondaryId) + ", " +
	  "'"+ secondarySourceTable + "', " +
	  "'"+ auth + "', " +
	  "'"+ subsource+"'" ;
    } 
  /** String for output of status */
  public String toOutputString()
    {
      return id +" : "+ controlGroup +" "+ sourceTable +" " + 
	state +"    "+ rank + "  "+result;
    }

  public static String fieldString()
    {
	return 	" id, controlGroup, sourceTable, state, rank, result," +
	" secondaryId, secondarySourceTable, " +
	" auth, subsource";
    }

  /** Parse resultset into this ProcessRow */  
  public static ProcessRow parse (ResultSet rs)
    {
      ProcessRow pr = new ProcessRow();
        try {

	  pr.id			= rs.getInt("id"); 
	  pr.controlGroup	= getStringSafe(rs, "controlGroup");
	  pr.sourceTable	= getStringSafe(rs, "sourceTable");
	  pr.state		= getStringSafe(rs, "state");
	  pr.rank		= rs.getInt("rank");
	  pr.result		= rs.getInt("result");
	  pr.secondaryId  	= rs.getInt("secondaryId");
	  
	  pr.secondarySourceTable = getStringSafe(rs, "secondarySourceTable");
	  pr.auth		= getStringSafe(rs, "auth");
	  pr.subsource		= getStringSafe(rs, "subsource");
	  pr.lddate      	= rs.getDate("lddate");
	  
	} catch ( NullPointerException ex) {
            System.err.println("NullPointerException in parseResults");
            ex.printStackTrace(System.err);
	    return null;
        } catch ( SQLException ex) {
            System.err.println("SQLException");
            ex.printStackTrace(System.err);;
	    return null;
        }

	return pr;
    }
/** 
 * Allow safe building of INSERT and UPDATE commands when some fields can be null 
 */
    public static String znull(float val)
    {
        if (val == 0.0) return "NULL";
        return String.valueOf(val);
    }

    public static String znull(int ival)
    {
        if (ival == 0) return "NULL";
        return String.valueOf(ival);
    }
    static String getStringSafe(ResultSet rs, String column)
    {
        try{
            String str = rs.getString(column);
            if (str == null) return "";
            return str;
        } catch ( NullPointerException ex) {
            System.err.println("NullPointerException");
            ex.printStackTrace(System.err);
            return "";
        } catch ( SQLException ex) {
            System.err.println("SQLException");
            ex.printStackTrace(System.out);
            return "";
        }
    }



}
