package org.trinet.jiggle;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.swing.*;
//import org.trinet.jdbc.*;	// Allan's package
import org.trinet.jasi.*;

/**
 * Present the Phase pick popup menu
 */
public class PhasePopup {

 /** The MasterView */
  MasterView mv;

  /** Waveform panel pick is being made in*/
  WFPanel wfp;

  /** The actual popup menu. */
  JPopupMenu popup = new JPopupMenu();
  PhasePopupListener listener = new PhasePopupListener();

    /** The epoch time of the pick */
  double pickTime;

  /** String contining the software's guess at the phase that was picked. */
  String guess;

    /** The resulting phase */
  Phase newph;

  /** The currently selected Solution */
  Solution sol;

    /**
     * Create a PhasePopup. The WFPanel is needed to get
     * info on the waveform and panel being picked. The MasterView is
     * used to help figure out which phase this is; P or S.<p>
     * The PhasePopup is created fresh each invocation because the top
     * menu item changes with each pick.
     */
public PhasePopup(Component refComp,
		  ActiveWFPanel wfp,
		  Point location)  {

    this.wfp = wfp;
    this.mv  = wfp.wfv.mv;

    // current active solution
    sol = mv.getSelectedSolution();

    // Figure the picktime of the bombsight
    pickTime = mv.masterWFWindowModel.getTimeSpan().getCenter();

// Make tentitive phase: guess at pick type and description and put as first
// menu item
    newph = wfp.wfv.describePickAt(pickTime, sol);

    createPhasePopup();

    //popup is located relative to 'refComp'

    popup.show(refComp, location.x, location.y);
}

private void createPhasePopup ()
{

    guess = newph.description.toShortString();

    JMenuItem sameItem = addExpressItem(guess);
    popup.addSeparator();

// add the P choices
    addExpressItem ("iP0");
    addExpressItem ("iP1");
    addExpressItem ("eP2");
    addExpressItem ("eP3");
    addExpressItem ("eP4");

    popup.addSeparator();

// add the S choices
    addExpressItem ("iS0");
    addExpressItem ("iS1");
    addExpressItem ("eS2");
    addExpressItem ("eS3");
    addExpressItem ("eS4");

    popup.addSeparator();

// add other functions
    addExpressItem("Cancel");
    addExpressItem("Delete");

    popup.addSeparator();

    addExpressItem("More...");

//    popup.addMouseListener ( new MsHandler() );           // mouse button handler

}

/**
 * Streamline adding of menu items
 */
    private JMenuItem addExpressItem(String text)
    {
	JMenuItem item = popup.add(new JMenuItem(text));
	item.addActionListener(listener);

	return item;
    }

/**
 * Menu ActionListener
 */
//TODO: the final disposition of the phase should be handled by a MVC model.

    class PhasePopupListener implements ActionListener {
	public void actionPerformed (ActionEvent evt) {

	    JMenuItem mi = (JMenuItem) evt.getSource();

	    String str = mi.getText();

	    //Cancel the current pick interaction, don't change anything
	    if ( str.equals("Cancel") ) {
		return;
	    }

	    // delete the nearest pick
	    if ( str.equals("Delete") )  {

          sol.deletePhase(wfp.wfv.phaseList.getNearestPhase(pickTime, sol));

		return ;
	    }

	    if (str.equals("More...")) {
		//		System.out.println ("More...");

		// dialog needs the parent frame (Jiggle)
		Frame frame  = (Frame) wfp.getTopLevelAncestor();

		//		System.out.println ("Opening PhaseDialog...");
		PhaseDialog dia = new PhaseDialog( frame, popup, wfp,  mv, newph) ;

		return ;
	    }

// an express menu item was selected

	    // parse the string in the menu item (fm is already set)
	    newph.description.parseShortString(str, wfp.wfv.getChannelObj());

         // associate phase with current solution
         newph.associate(sol);

         // add it to the Solution phase list
	    sol.addOrReplacePhase(newph);

	return ;

	}
    }

}


