package org.trinet.jasi.coda;
/** Type of coda ('P', 'S', etc.) */
public class CodaType {
    public final static CodaType P = new CodaType(1, "P");
    public final static CodaType S = new CodaType(2, "S");

    private int id;
    private String type;

    private CodaType(int id, String type) {
        this.id = id;
        this.type = type;
    }

    int getId() { return id;}

    String getName() { return type;}

    public static CodaType getCodaType(int id) {
        if (id == 1) return P;
        if (id == 2) return S;
        return null;
    }
    public static CodaType getCodaType(String typeName) {
        if (typeName.equalsIgnoreCase("S")) return S;
        if (typeName.equalsIgnoreCase("P")) return P;
        return null;
    }

    public String toString() {
        return String.valueOf(id) + " " + type;
    }
}

