package org.trinet.jasi;

import org.trinet.util.DateTime;

/**
 *  A single sample. Has a time (epoch time) and a value (amplitude). The
 * units of the ampltude are unspecified and could be counts, cm/sec, etc.
 */

public class Sample

{
    public double datetime = 0.0;
    public double value    = 0.0;
    boolean isNull = true;

    public Sample()
    {
    }

    public Sample(double time, int val)
    {
	set ( time, (double) val);
    }
    public Sample(Sample samp)
    {
      	set (samp.datetime, samp.value);
    }
    public Sample(double time, double val)
    {
	set (time, val);
    }

    public void set (double time, double val) {
      setDatetime(time);
      setValue(val);
    }
    public void setDatetime ( double time ) {
      datetime = time;
      setNotNull();
    }
    public void setValue ( double val ) {
      value = val;
      setNotNull();
    }

/** Returns true if no value or time has been set for this Sample. */
    public boolean isNull() {
      return isNull;
    }

    private void setNotNull() {isNull = false;}

    public String toString()
    {
	DateTime dt = new DateTime(datetime);

	return dt.toString() + " " + value;
    }

    /** Return the time difference between samples. */
    public double timeDiff (Sample samp) {
	return datetime - samp.datetime;
    }

    /** Return a copy of oneself. */
    public Sample copy() {
      return new Sample(datetime, value);
    }
    /** Return the Sample with the maximum value. Returns null if BOTH Samples
    * are null.  If one Sample is null returns the non-null Sample. */
    public static Sample max (Sample s1, Sample s2) {
      if (s1 == null) return s2;
      if (s2 == null) return s1;

      if (s1.value > s2.value) return s1;
      return s2;
    }
    /** Return the Sample with the minimum value. Returns null if BOTH Samples
    * are null. If one Sample is null returns the non-null Sample.*/
    public static Sample min (Sample s1, Sample s2) {
      if (s1 == null) return s2;
      if (s2 == null) return s1;

      if (s1.value < s2.value) return s1;
      return s2;
    }
    /** Return the Sample with the maximum absolute value. Returns null if BOTH Samples
    * are null.  If one Sample is null returns the non-null Sample. */
    public static Sample absMax (Sample s1, Sample s2) {
      if (s1 == null) return s2;
      if (s2 == null) return s1;

      if (Math.abs(s1.value) > Math.abs(s2.value)) return s1;
      return s2;
    }
} // end of class
