package org.trinet.jasi;

import org.trinet.jdbc.datatypes.DataDouble;
import org.trinet.util.TimeSpan;

/**
 * A correction to be added to a ChannelMag for a particular magnitude type.
 * @See: org.trinet.util.TimeBoundedObject()
 */

public class ChannelMagCorrection extends org.trinet.util.TimeBoundedObject {

// Time related methods are inherited from TimeBoundedObject

/** The correction value to be added to the ChannelMag. */
  DataDouble value;

/** String describing the magnitude type. Example: "ml", "md" */
  String type;

  public ChannelMagCorrection(String type, double value, TimeSpan timespan) {
    set (type, value, timespan);
  }

  /** Set the parameters for this correction. */
  public void set (String type, double value, TimeSpan timespan) {
    setType(type);
    setValue(value);
    setTimespan(timespan);
  }

/** Set String describing the magnitude type. Example: "ml", "md" */
  public void setType (String typ) {
    type = typ;
  }
/** Get String describing the magnitude type. Example: "ml", "md". To be safe
 comparisons should be done with String.equalsIgnoreCase().  */
  public String getType () {
    return type;
  }
  public void setValue(double val) {
    value.setValue(val);
  }
  public void setValue(DataDouble val) {
    value.setValue(val);
  }

  public DataDouble getValue() {
    return value;
  }

/** Return a hash code value that is derived from the timespan and mag type of
 * this ChannelMagCorrection. */
  public int hashCode () {
    // use modulo operator to "wrap" if hash value gets too big for an int
    return (getTimeSpan().hashCode() + type.hashCode()) % Integer.MAX_VALUE;
  }

}