package org.trinet.apps;

import org.trinet.jiggle.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;

import org.trinet.jasi.*;
import org.trinet.util.*;
import org.trinet.util.WaveClient;

/**
 * GUI to allow viewing of current data for a set of channels. <p>
 *
 * Usage: Scope <seconds> "<nt.sta.chan nt.sta.chan ...>"
 */

public class Scope {

    static final String versionNumber  = "2002.05.16";

    MasterView mv = new MasterView();

    JFrame frame;
    WFScroller wfScroller = new WFScroller();
    ZoomPanel zpanel = new ZoomPanel();
    JSplitPane waveSplit = new JSplitPane();

    String waveServerFile = "";

    ChannelList chanList = new ChannelList();

    int duration = 120;

    int panelsInView = 10;
    int secsInView = 60;

    public Dimension singlePanelSize = new Dimension (640, 60);

    public static String defaulthost = "k2";
    public static String host = defaulthost;
    public static String dbasename = defaulthost+"db";

    static boolean debug = true;
//    static boolean debug = false;

    public Scope() {

    }


    public static void main (String args[])
    {
  // create an instance else everything must be 'static'
        Scope scope = new Scope();

  if (args.length < 2)	// insufficient args
  {
    System.out.println ("Usage: Scope <seconds> \"<nt.sta.chan nt.sta.chan ...>\"");
    System.exit(0);
  }

     // read props file to get waveserver filename
       JiggleProperties props = new JiggleProperties("properties");

     try {
         // Make a WaveClient
            WaveServerGroup waveClient = props.getWaveServerGroup();

         int nservers = waveClient.numberOfServers();
         if (nservers <= 0) {
       System.err.println(
       "getDataFromWaveServer Error: no waveservers specified in properties file: " +
              scope.waveServerFile);
       System.exit(-1);
         }
            Waveform.setWaveSource (waveClient);
      }
     catch (Exception ex) {
         System.err.println(ex.toString());
         ex.printStackTrace();
     }

        // duration of data capture
    Integer val = Integer.valueOf(args[0]);
    scope.duration = (int) val.intValue();

       // parse the sta list and make a ChannelList
       StringTokenizer strTok = new StringTokenizer(args[1], " ,\t\n\r\f");
       while (strTok.hasMoreElements()) {
          ChannelName cn = ChannelName.fromDelimitedString(strTok.nextToken(), ".");
          scope.chanList.add(Channel.create().setChannelName(cn));
          if (debug) System.out.println (cn.toString());
       }
        System.out.println ("Making connection...");
  DataSource init = new TestDataSource(host);  // make connection
  init.setWriteBackEnabled(true);

  scope.startup();
    }

    void startup () {
// Make graphics components
//        waveSplit = makeWaveSplit();

  JButton refreshButton = new JButton("REFRESH");
  refreshButton.addActionListener(new ActionListener() {
       public void actionPerformed(ActionEvent e) {
          refreshGUI();
       }
  });
// make a main frame
        frame = new JFrame("Scope v."+ versionNumber);

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

        frame.getContentPane().add(waveSplit, BorderLayout.CENTER);	    // add splitPane to frame
  frame.getContentPane().add(refreshButton, BorderLayout.SOUTH );
        frame.pack();
        frame.setVisible(true);

  int height = 900;
  int width  = 640;
  frame.setSize(width, height);	// must be done AFTER setVisible

      //debug

     System.out.println ("++++++++++++++++++++++++++++++++++++++++++++++++++++");
     System.out.println ("WFView count        = "+ mv.getWFViewCount());
     System.out.println ("masterWFPanelModel  = "+ mv.masterWFViewModel.countListeners());
     System.out.println ("masterWFWindowModel = "+ mv.masterWFWindowModel.countListeners());
     System.out.println ("++++++++++++++++++++++++++++++++++++++++++++++++++++");

     // get and display the data
      refreshGUI();
    }
    void refreshGUI () {

  if (debug) System.out.println ("Creating GUI...");

  frame.getContentPane().remove(waveSplit);  // remove old one

  // make new graphics from new masterView
  mv = makeMasterView(chanList, duration);
  waveSplit = makeWaveSplit(mv);

  frame.getContentPane().add(waveSplit, BorderLayout.CENTER);	    // add splitPane to frame

        wfScroller.setSecondsInViewport(secsInView);
  setSelectedInZoom(mv);
  frame.validate();
    }

/** */
   JSplitPane makeWaveSplit(MasterView mv) {

  boolean isActive = true;
  wfScroller = new WFScroller(mv, panelsInView, isActive);
  wfScroller.setShowRowHeader(true);
      wfScroller.setMinimumSize(new Dimension(300, 100) );

  zpanel = new ZoomPanel(mv);
  // set minsize or splitpane won't move
  zpanel.setMinimumSize(new Dimension(100, 100) );

  // make a split pane with the zpanel and wfScroller
  JSplitPane waveSplit =
      new JSplitPane(JSplitPane.VERTICAL_SPLIT,
         false,       // don't repaint until resizing is done
         zpanel,      // top component
         wfScroller); // bottom component
  waveSplit.setOneTouchExpandable(true);
  waveSplit.setDividerLocation(0.5);

  return waveSplit;

  }

    void setSelectedInZoom(MasterView mv) {
          // Retain previously selected WFPanel if there is one,
    // if none default to the first WFPanel in the list
   WFView wfvSel = mv.masterWFViewModel.get();
   // none selected, use the 1st one in the scroller
   if (wfvSel == null && mv.getWFViewCount() > 0) {
    wfvSel = (WFView) mv.wfvList.get(0);
   }

    // Must reset selected WFPanel because PickingPanel and WFScroller are
    // new and must be notified (via listeners) of the selected WFPanel.  It might
    // be null if no data is loaded.
     if (wfvSel != null ) {
       wfScroller.groupPanel.getWFPanel(wfvSel).setSelected(true);
       mv.masterWFViewModel.set(wfvSel);
       mv.masterWFWindowModel.setFullView(wfvSel.getWaveform());
     }
    }
    /**
     * Returns a new MasterView containing wf's for the set of channels with a
     * time window starting now and going back 'dur' seconds
     */
  public MasterView makeMasterView (ChannelList chanList, double dur) {

       double padding = 0.0;    // seconds

       double end = new DateTime().getEpochSeconds();
       System.out.println(EpochTime.toString(end));
       // cut some slack, latancy is not 0
       end = end - padding;            // backoff 20 secs
       double start = end - dur;

      // make a new view list with current time window
       ArrayList viewList = new ArrayList(chanList.size());

       // make a list of channel time windows
       for (int i = 0 ; i< chanList.size(); i++) {
//		viewList.add(new  TriggerChannelTimeWindow(
    viewList.add(new  ChannelTimeWindow(
                (Channel) chanList.get(i),
          start, end
          ));
       }

      // define the Master View
      mv.destroy();       // destroy previous, free listeners, etc.
      mv = new MasterView();
      //mv.defineByTriggerChannelTimeWindowList(viewList);
      mv.defineByChannelTimeWindowList(viewList);

      mv.setLoadChannelData(true);
      mv.loadChannelData();
      mv.setWaveFormLoadMode(MasterView.LoadAllInBackground);

      return mv;
  }

} // EventViewer

